/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.client;

import com.caucho.amqp.client.AmqpClientSender;
import com.caucho.amqp.common.AmqpSenderLink;
import com.caucho.message.SettleMode;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmqpClientSenderLink
extends AmqpSenderLink {
    private static final Logger log = Logger.getLogger(AmqpClientSenderLink.class.getName());
    private final AmqpClientSender<?> _sender;

    public AmqpClientSenderLink(String name, String address, AmqpClientSender<?> sender) {
        super(name, address);
        this._sender = sender;
    }

    public long nextMessageId() {
        return 3L;
    }

    public AmqpClientSender<?> getSender() {
        return this._sender;
    }

    @Override
    public Map<String, Object> getAttachProperties() {
        return this._sender.getAttachProperties();
    }

    @Override
    public Map<String, Object> getSourceProperties() {
        return this._sender.getSourceProperties();
    }

    @Override
    public Map<String, Object> getTargetProperties() {
        return this._sender.getTargetProperties();
    }

    long transfer(SettleMode settleMode, InputStream is) {
        long mid = this.nextMessageId();
        this.transfer(mid, settleMode, is);
        return mid;
    }

    @Override
    public void onAccepted(long xid, long messageId) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " onAccepted(" + messageId + ")");
        }
        this.getSender().onAccepted(messageId);
    }

    public void detach() {
    }
}

