/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.common.AmqpLinkFactory;
import com.caucho.amqp.common.AmqpReceiverLink;
import com.caucho.amqp.common.AmqpSession;
import com.caucho.amqp.io.AmqpConnectionReader;
import com.caucho.amqp.io.AmqpConnectionWriter;
import com.caucho.amqp.io.AmqpFrameHandler;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.amqp.io.FrameAttach;
import com.caucho.amqp.io.FrameBegin;
import com.caucho.amqp.io.FrameClose;
import com.caucho.amqp.io.FrameDetach;
import com.caucho.amqp.io.FrameDisposition;
import com.caucho.amqp.io.FrameEnd;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.amqp.io.FrameTransfer;
import com.caucho.amqp.io.LinkSource;
import com.caucho.amqp.io.LinkTarget;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AmqpConnectionHandler
implements AmqpFrameHandler {
    private static final Logger log = Logger.getLogger(AmqpConnectionHandler.class.getName());
    private final AmqpLinkFactory _linkFactory;
    private AmqpConnectionReader _in;
    private AmqpConnectionWriter _out;
    private AmqpSession[] _sessions = new AmqpSession[1];

    public AmqpConnectionHandler(AmqpLinkFactory linkFactory, ReadStream is, WriteStream os) {
        this._linkFactory = linkFactory;
        this._out = new AmqpConnectionWriter(os);
        this._in = new AmqpConnectionReader(is, this);
    }

    public AmqpConnectionReader getReader() {
        return this._in;
    }

    public AmqpConnectionWriter getWriter() {
        return this._out;
    }

    public AmqpSession beginSession() {
        this._sessions[0] = new AmqpSession(this);
        this.getWriter().writeBegin();
        return this._sessions[0];
    }

    @Override
    public void onBegin(FrameBegin beginRequest) throws IOException {
        if (this._sessions[0] == null) {
            this._sessions[0] = new AmqpSession(this);
            FrameBegin beginResponse = new FrameBegin();
            this._out.sendFrame(beginResponse);
        }
    }

    private void endSession(int channel) {
        FrameEnd end = new FrameEnd();
        this._out.sendFrame(end);
    }

    @Override
    public void onEnd(FrameEnd clientEnd) throws IOException {
        AmqpSession session = this._sessions[0];
        this._sessions[0] = null;
        if (session != null) {
            FrameEnd sessionEnd = new FrameEnd();
            this._out.sendFrame(sessionEnd);
        }
    }

    @Override
    public void onAttach(FrameAttach attach) {
        String address;
        AmqpSession session = this._sessions[0];
        String name = attach.getName();
        AmqpLink link = session.findOutgoingLink(name);
        if (link != null) {
            link.setIncomingHandle(attach.getHandle());
            session.addIncomingLink(link);
            this.onAttachAck(link, attach);
            return;
        }
        SettleMode settleMode = attach.getSenderSettleMode() == FrameAttach.SenderSettleMode.SETTLED || attach.getSenderSettleMode() == FrameAttach.SenderSettleMode.MIXED ? SettleMode.ALWAYS : (attach.getReceiverSettleMode() == FrameAttach.ReceiverSettleMode.FIRST ? SettleMode.EXACTLY_ONCE : SettleMode.AT_LEAST_ONCE);
        if (attach.getRole() == FrameAttach.Role.SENDER) {
            LinkTarget target = attach.getTarget();
            address = target.getAddress();
            Map<String, Object> targetProperties = target.getDynamicNodeProperties();
            link = this._linkFactory.createReceiverLink(name, address, targetProperties);
        } else {
            LinkSource source = attach.getSource();
            address = source.getAddress();
            DistributionMode distMode = source.getDistributionMode();
            Map<String, Object> sourceProperties = source.getDynamicNodeProperties();
            link = this._linkFactory.createSenderLink(name, address, distMode, settleMode, sourceProperties);
        }
        link.setIncomingHandle(attach.getHandle());
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " onAttach(" + address + "," + (Object)((Object)settleMode) + ")");
        }
        session.onAttach(link);
    }

    private void onAttachAck(AmqpLink link, FrameAttach attach) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(link + " onAttachAck()");
        }
        if (link.getRole() == FrameAttach.Role.RECEIVER) {
            AmqpReceiverLink receiver = (AmqpReceiverLink)link;
            receiver.setPeerDeliveryCount(attach.getInitialDeliveryCount());
        }
    }

    public void closeSender(AmqpLink link) {
        AmqpSession session = this._sessions[0];
        int handle = link.getOutgoingHandle();
        session.detachOutgoingLink(handle);
        link.setOutgoingHandle(-1);
        if (link != null) {
            FrameDetach detach = new FrameDetach();
            detach.setHandle(handle);
            this._out.sendFrame(detach);
        }
    }

    @Override
    public void onDetach(FrameDetach clientDetach) throws IOException {
        FrameDetach serverDetach = new FrameDetach();
        serverDetach.setHandle(clientDetach.getHandle());
        this._out.sendFrame(serverDetach);
    }

    @Override
    public void onTransfer(AmqpReader ain, FrameTransfer transfer) throws IOException {
        AmqpSession session = this._sessions[0];
        session.onTransfer(transfer, ain);
    }

    @Override
    public void onDisposition(FrameDisposition disposition) throws IOException {
        AmqpSession session = this._sessions[0];
        DeliveryState state = disposition.getState();
        long xid = 0L;
        long first = disposition.getFirst();
        long last = disposition.getLast();
        if (disposition.getRole() == FrameAttach.Role.SENDER) {
            session.onReceiverDisposition(xid, state, first, last);
        } else {
            session.onReceiverDisposition(xid, state, first, last);
        }
    }

    public void flow(AmqpLink link, long deliveryCount, int credit) {
        FrameFlow flow = new FrameFlow();
        flow.setHandle(link.getOutgoingHandle());
        flow.setDeliveryCount(deliveryCount);
        flow.setLinkCredit(credit);
        this.getWriter().sendFrame(flow);
    }

    @Override
    public void onFlow(FrameFlow flow) throws IOException {
        AmqpSession session = this._sessions[0];
        session.onFlow(flow);
    }

    @Override
    public void onClose(FrameClose clientClose) throws IOException {
        try {
            FrameClose serverClose = new FrameClose();
            this._out.sendFrame(serverClose);
        }
        finally {
            this.disconnect();
        }
    }

    public void closeSessions() {
        for (int i = 0; i < this._sessions.length; ++i) {
            AmqpSession session = this._sessions[i];
            this._sessions[i] = null;
            if (session == null) continue;
            this.endSession(i);
        }
    }

    public void closeConnection() {
        FrameClose close = new FrameClose();
        this._out.sendFrame(close);
    }

    private void disconnect() {
    }
}

