/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpConstants;
import com.caucho.amqp.io.AmqpPacketMap;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.util.L10N;
import java.io.IOException;

public abstract class AmqpAbstractPacket
implements AmqpConstants {
    private static final L10N L = new L10N(AmqpAbstractPacket.class);

    public void write(AmqpWriter out) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void read(AmqpReader in) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void readValue(AmqpReader in) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected long getDescriptorCode() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public AmqpAbstractPacket createInstance() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    static <T extends AmqpAbstractPacket> T readType(AmqpReader in, long typeCode, Class<T> type) throws IOException {
        AmqpAbstractPacket factory = AmqpPacketMap.getPacket(typeCode);
        if (factory == null) {
            throw new IOException(L.l("0x{0} is an unknown type expected {1}", (Object)Long.toHexString(typeCode), (Object)type.getName()));
        }
        AmqpAbstractPacket packet = factory.createInstance();
        if (!type.isAssignableFrom(packet.getClass())) {
            throw new ClassCastException(L.l("Cannot cast {0} to {1}", (Object)packet.getClass().getName(), (Object)type.getName()));
        }
        packet.readValue(in);
        return (T)packet;
    }
}

