/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractPacket;
import com.caucho.amqp.io.AmqpError;
import com.caucho.amqp.io.DeliveryAccepted;
import com.caucho.amqp.io.DeliveryModified;
import com.caucho.amqp.io.DeliveryRejected;
import com.caucho.amqp.io.DeliveryReleased;
import com.caucho.amqp.io.FrameAttach;
import com.caucho.amqp.io.FrameBegin;
import com.caucho.amqp.io.FrameClose;
import com.caucho.amqp.io.FrameDetach;
import com.caucho.amqp.io.FrameDisposition;
import com.caucho.amqp.io.FrameEnd;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.amqp.io.FrameOpen;
import com.caucho.amqp.io.FrameTransfer;
import com.caucho.amqp.io.LinkSource;
import com.caucho.amqp.io.LinkTarget;
import com.caucho.amqp.io.MessageAnnotations;
import com.caucho.amqp.io.MessageAppProperties;
import com.caucho.amqp.io.MessageDeliveryAnnotations;
import com.caucho.amqp.io.MessageFooter;
import com.caucho.amqp.io.MessageHeader;
import com.caucho.amqp.io.MessageProperties;
import java.util.HashMap;

public final class AmqpPacketMap {
    private static final HashMap<Long, AmqpAbstractPacket> _typeMap = new HashMap();

    static AmqpAbstractPacket getPacket(long descriptor) {
        return _typeMap.get(descriptor);
    }

    private static void addType(AmqpAbstractPacket factory) {
        _typeMap.put(factory.getDescriptorCode(), factory);
    }

    static {
        AmqpPacketMap.addType(new FrameOpen());
        AmqpPacketMap.addType(new FrameBegin());
        AmqpPacketMap.addType(new FrameAttach());
        AmqpPacketMap.addType(new FrameFlow());
        AmqpPacketMap.addType(new FrameTransfer());
        AmqpPacketMap.addType(new FrameDisposition());
        AmqpPacketMap.addType(new FrameDetach());
        AmqpPacketMap.addType(new FrameEnd());
        AmqpPacketMap.addType(new FrameClose());
        AmqpPacketMap.addType(new LinkSource());
        AmqpPacketMap.addType(new LinkTarget());
        AmqpPacketMap.addType(new DeliveryAccepted());
        AmqpPacketMap.addType(new DeliveryRejected());
        AmqpPacketMap.addType(new DeliveryReleased());
        AmqpPacketMap.addType(new DeliveryModified());
        AmqpPacketMap.addType(new MessageHeader());
        AmqpPacketMap.addType(new MessageDeliveryAnnotations());
        AmqpPacketMap.addType(new MessageAnnotations());
        AmqpPacketMap.addType(new MessageProperties());
        AmqpPacketMap.addType(new MessageAppProperties());
        AmqpPacketMap.addType(new MessageFooter());
        AmqpPacketMap.addType(new AmqpError());
    }
}

