/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.marshal;

import com.caucho.amqp.io.AmqpWriter;
import com.caucho.amqp.io.MessageProperties;
import com.caucho.amqp.marshal.AmqpMessageEncoder;
import com.caucho.message.MessagePropertiesFactory;
import java.io.IOException;

public abstract class AbstractMessageEncoder<T>
implements AmqpMessageEncoder<T> {
    @Override
    public boolean isDurable(MessagePropertiesFactory<T> factory, T value) {
        return factory.isDurable();
    }

    @Override
    public int getPriority(MessagePropertiesFactory<T> factory, T value) {
        return factory.getPriority();
    }

    @Override
    public long getTimeToLive(MessagePropertiesFactory<T> factory, T value) {
        return factory.getTimeToLive();
    }

    @Override
    public boolean isFirstAcquirer(MessagePropertiesFactory<T> factory, T value) {
        return factory.isFirstAcquirer();
    }

    @Override
    public String getContentType(T value) {
        return null;
    }

    @Override
    public void encode(AmqpWriter out, MessagePropertiesFactory<T> factory, T value) throws IOException {
        this.encodeDeliveryAnnotations(out, factory, value);
        this.encodeMessageAnnotations(out, factory, value);
        this.encodeApplicationProperties(out, factory, value);
        this.encodeData(out, value);
        this.encodeFooters(out, factory, value);
    }

    protected void encodeDeliveryAnnotations(AmqpWriter out, MessagePropertiesFactory<T> factory, T value) throws IOException {
    }

    protected void encodeMessageAnnotations(AmqpWriter out, MessagePropertiesFactory<T> factory, T value) throws IOException {
    }

    protected void encodeProperties(AmqpWriter out, MessagePropertiesFactory<T> factory, T value) throws IOException {
        String contentType = this.getContentType(value);
        if (contentType != null) {
            MessageProperties properties = new MessageProperties();
            properties.setContentType(contentType);
            properties.write(out);
        }
    }

    protected void encodeApplicationProperties(AmqpWriter out, MessagePropertiesFactory<T> factory, T value) throws IOException {
    }

    @Override
    public abstract void encodeData(AmqpWriter var1, T var2) throws IOException;

    protected void encodeFooters(AmqpWriter out, MessagePropertiesFactory<T> factory, T value) throws IOException {
    }
}

