/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.client;

import com.caucho.bam.BamError;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.client.LinkConnection;
import com.caucho.bam.client.LinkConnectionFactory;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OutboundMessageStream
implements MessageStream {
    private static final Logger log = Logger.getLogger(OutboundMessageStream.class.getName());
    private final LinkConnectionFactory _linkFactory;
    private final Broker _inboundBroker;
    private final AtomicReference<LinkConnection> _connRef = new AtomicReference();

    public OutboundMessageStream(LinkConnectionFactory linkFactory, Broker inboundBroker) {
        if (linkFactory == null) {
            throw new NullPointerException();
        }
        if (inboundBroker == null) {
            throw new NullPointerException();
        }
        this._linkFactory = linkFactory;
        this._inboundBroker = inboundBroker;
    }

    @Override
    public String getAddress() {
        LinkConnection conn = this._connRef.get();
        if (conn != null) {
            return conn.getAddress();
        }
        return null;
    }

    @Override
    public Broker getBroker() {
        return this._inboundBroker;
    }

    @Override
    public boolean isClosed() {
        return this._linkFactory.isClosed();
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        try {
            this.getLink().message(to, from, payload);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            this.getBroker().messageError(from, to, payload, BamError.create(e));
        }
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        try {
            this.getLink().messageError(to, from, payload, error);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        try {
            MessageStream link = this.getLink();
            if (link != null) {
                link.query(id, to, from, payload);
            } else {
                this.getBroker().queryError(id, from, to, payload, new BamError("link closed"));
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            this.getBroker().queryError(id, from, to, payload, BamError.create(e));
        }
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        try {
            this.getLink().queryResult(id, to, from, payload);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        try {
            this.getLink().queryError(id, to, from, payload, error);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    private MessageStream getLink() {
        LinkConnection conn = this._connRef.get();
        if (conn != null && conn.isClosed()) {
            conn = null;
        }
        if (conn == null) {
            conn = this._linkFactory.open(this.getBroker());
            if (!this._connRef.compareAndSet(null, conn)) {
                // empty if block
            }
            conn = this._connRef.get();
        }
        return conn.getOutboundStream();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._linkFactory + "]";
    }
}

