/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.stream;

import com.caucho.bam.BamError;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMessageStream
implements MessageStream {
    private static final Logger log = Logger.getLogger(AbstractMessageStream.class.getName());

    @Override
    public String getAddress() {
        Broker broker = this.getBroker();
        if (broker != null) {
            return this.getClass().getSimpleName() + "@" + this.getBroker().getAddress();
        }
        return this.getClass().getSimpleName() + "@";
    }

    @Override
    public Broker getBroker() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " message ignored " + payload + " {from:" + from + ", to:" + to + "}");
        }
        String msg = this + ": message is not implemented for this payload\n  " + payload + "\n  {from:" + from + ", to:" + to + "}";
        BamError error = new BamError("cancel", "feature-not-implemented", msg);
        Broker linkStream = this.getBroker();
        if (linkStream != null) {
            linkStream.messageError(from, to, payload, error);
        }
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " messageError ignored " + error + " " + payload + " {from:" + from + ", to:" + to + "}");
        }
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " query not implemented " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
        String msg = this + ": query is not implemented for this payload\n  " + payload + "\n  {id:" + id + ", from:" + from + ", to:" + to + "}";
        BamError error = new BamError("cancel", "feature-not-implemented", msg);
        Broker broker = this.getBroker();
        if (broker == null) {
            throw new IllegalStateException(this + ".getBroker() did not return a Broker, which is needed to send an error for a query");
        }
        broker.queryError(id, from, to, payload, error);
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " queryResult ignored " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " queryError ignored " + error + " " + payload + " {id:" + id + ", from:" + from + ", to:" + to + "}");
        }
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "]";
    }
}

