/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.JmxCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.JmxCallQueryReply;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;
import java.util.HashSet;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class JmxCallCommand
extends JmxCommand {
    private static final L10N L = new L10N(JmxCallCommand.class);
    private static final Set<String> options = new HashSet<String>();

    @Override
    protected void initBootOptions() {
        this.addValueOption("pattern", "pattern", "pattern to match MBean");
        this.addValueOption("operation", "operation", "operation to invoke");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "calls a JMX operation on a server MBean";
    }

    @Override
    public String getUsageArgs() {
        return " value...";
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String[] trailingArgs = args.getDefaultArgs();
        String pattern = args.getArg("-pattern");
        if (pattern == null) {
            throw new ConfigException(L.l("jmx-call must specify -pattern"));
        }
        try {
            ObjectName.getInstance(pattern);
        }
        catch (MalformedObjectNameException e) {
            throw new ConfigException(L.l("incorrect pattern `{0}' :`{`}'", (Object)pattern, (Object)e.getMessage()));
        }
        String operation = args.getArg("-operation");
        if (operation == null) {
            throw new ConfigException(L.l("jmx-call must specify -operation"));
        }
        int operationIndex = -1;
        if (operation.contains(":")) {
            int i = operation.indexOf(58);
            String name = operation.substring(0, i);
            String index = operation.substring(i + 1, operation.length());
            operation = name;
            operationIndex = Integer.parseInt(index);
        }
        JmxCallQueryReply reply = managerClient.callJmx(pattern, operation, operationIndex, trailingArgs);
        String message = L.l("method `{0}' called on `{1}' returned `{2}'.", (Object)reply.getOperation(), (Object)reply.getBean(), (Object)reply.getReturnValue());
        System.out.println(message);
        return 0;
    }
}

