/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.config.Configurable;
import com.caucho.config.annotation.NoAspect;
import com.caucho.config.program.ConfigProgram;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.QJniServerSocket;
import com.caucho.vfs.QServerSocket;
import com.caucho.vfs.SSLFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Logger;

@NoAspect
public class OpenPort {
    private static final Logger log = Logger.getLogger(OpenPort.class.getName());
    private String _protocol;
    private String _address;
    private InetAddress _socketAddress;
    private int _port;
    private boolean _isJsse;

    public String getProtocolName() {
        return this._protocol;
    }

    public void setProtocolName(String protocol) {
        this._protocol = protocol;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    @Configurable
    public void setAddress(String address) throws UnknownHostException {
        if ("*".equals(address)) {
            address = null;
        }
        this._address = address;
        if (address != null) {
            this._socketAddress = InetAddress.getByName(address);
        }
    }

    public String getAddress() {
        return this._address;
    }

    public void addOpenssl(ConfigProgram program) {
    }

    public void addJsse(ConfigProgram program) {
        this._isJsse = true;
    }

    public QServerSocket bindForWatchdog() throws IOException {
        QServerSocket ss;
        if (this._port <= 0) {
            return null;
        }
        if (this._port >= 1024 && !CurrentTime.isTest()) {
            return null;
        }
        if (this._isJsse) {
            if (this._port < 1024) {
                log.warning(this + " cannot bind jsse in watchdog");
            }
            return null;
        }
        if (this._socketAddress != null) {
            ss = QJniServerSocket.createJNI(this._socketAddress, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to " + this._socketAddress.getHostName() + ":" + this._port);
        } else {
            ss = QJniServerSocket.createJNI(null, this._port);
            if (ss == null) {
                return null;
            }
            log.fine(this + " watchdog binding to *:" + this._port);
        }
        if (!ss.isJni()) {
            ss.close();
            return ss;
        }
        return ss;
    }

    public void addBuilderProgram(ConfigProgram program) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getProtocolName() + ":" + this.getAddress() + ":" + this.getPort() + "]";
    }

    public static class DummyOpenSSLFactory
    implements SSLFactory {
        public void addBuilderProgram(ConfigProgram program) {
        }

        @Override
        public QServerSocket create(InetAddress host, int port) {
            return null;
        }

        @Override
        public QServerSocket bind(QServerSocket ss) {
            return null;
        }
    }
}

