/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.util.IoUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class ThreadDumpCommand
extends AbstractManagementCommand {
    @Override
    protected void initBootOptions() {
        this.addValueOption("file", "file", "file name where thread dump will be stored");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "displays a JVM thread dump summary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        int n;
        block6: {
            StringQueryReply result = managerClient.doThreadDump();
            String fileName = args.getArg("-file");
            if (fileName == null) {
                System.out.println(result.getValue());
                return 0;
            }
            FileWriter out = null;
            try {
                File file = new File(fileName);
                out = new FileWriter(file);
                out.write(result.getValue());
                ((Writer)out).flush();
                System.out.println("Thread dump was written to `" + file.getCanonicalPath() + "'");
                n = 0;
                if (out == null) break block6;
            }
            catch (IOException e) {
                int n2;
                block7: {
                    try {
                        e.printStackTrace();
                        n2 = 4;
                        if (out == null) break block7;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            IoUtil.close(out);
                        }
                        throw throwable;
                    }
                    IoUtil.close(out);
                }
                return n2;
            }
            IoUtil.close(out);
        }
        return n;
    }

    @Override
    public boolean isProOnly() {
        return false;
    }
}

