/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.bam.Message;
import com.caucho.bam.actor.SimpleActor;
import com.caucho.boot.WatchdogChildProcess;
import com.caucho.boot.WatchdogStopQuery;
import com.caucho.server.resin.WarningMessage;
import java.io.Serializable;
import java.util.logging.Logger;

public class WatchdogChildActor
extends SimpleActor {
    private static final Logger log = Logger.getLogger(WatchdogChildActor.class.getName());
    private WatchdogChildProcess _child;

    WatchdogChildActor(WatchdogChildProcess watchdog) {
        this.setAddress("watchdog");
        this._child = watchdog;
    }

    public Serializable query(Serializable payload) {
        return this.getSender().query("resin@admin.resin.caucho", payload);
    }

    public void message(Serializable payload) {
        this.getSender().message("resin@admin.resin.caucho", payload);
    }

    public void sendShutdown() {
        this.getBroker().query(1L, "resin@admin.resin.caucho", "watchdog@admin.resin.caucho", new WatchdogStopQuery(""));
    }

    @Message
    public void onWarning(String to, String from, WarningMessage warning) {
        String msg = warning.getMessage();
        log.warning("Watchdog received warning from Resin[" + this._child.getId() + ",pid=" + this._child.getPid() + "]:\n  " + warning.getMessage());
        if (msg.startsWith("Shutdown:")) {
            this._child.setShutdownMessage(msg);
        }
    }
}

