/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.security;

import com.caucho.config.AdminLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.security.Authenticator;
import com.caucho.security.BasicPrincipal;
import com.caucho.security.DigestBuilder;
import com.caucho.security.DigestCredentials;
import com.caucho.util.Base64;
import java.lang.reflect.Type;
import java.security.MessageDigest;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;

public class SecurityService
extends AbstractResinSubSystem {
    public static final int START_PRIORITY = 30;
    private String _signatureSecret;
    private Authenticator _authenticator;

    public static SecurityService createAndAddService() {
        ResinSystem system = SecurityService.preCreate(SecurityService.class);
        SecurityService service = new SecurityService();
        system.addService(SecurityService.class, service);
        return service;
    }

    public static SecurityService getCurrent() {
        return ResinSystem.getCurrentService(SecurityService.class);
    }

    public void setSignatureSecret(String secret) {
        if ("".equals(secret)) {
            secret = null;
        }
        this._signatureSecret = secret;
    }

    public boolean isSystemAuthKey() {
        return this._signatureSecret != null;
    }

    public void setAuthenticator(Authenticator auth) {
        this._authenticator = auth;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public String getAlgorithm(String uid) {
        if (this._authenticator != null) {
            return this._authenticator.getAlgorithm(new BasicPrincipal(uid));
        }
        return "plain";
    }

    public String signSystem(String uid, String nonce) {
        try {
            String password = null;
            password = this._signatureSecret;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            if (uid != null) {
                digest.update(uid.getBytes("UTF-8"));
            }
            digest.update(nonce.getBytes("UTF-8"));
            if (password != null) {
                digest.update(password.getBytes("UTF-8"));
            }
            return Base64.encode(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String sign(String algorithm, String uid, String password, String nonce) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            if (uid != null) {
                digest.update(uid.getBytes("UTF-8"));
            }
            digest.update(nonce.getBytes("UTF-8"));
            if (password != null) {
                char[] pwDigest = DigestBuilder.getDigest(new BasicPrincipal(uid), algorithm, password.toCharArray(), algorithm.toCharArray());
                if (pwDigest != null) {
                    password = new String(pwDigest);
                }
                digest.update(password.getBytes("UTF-8"));
            }
            return Base64.encode(digest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] sign(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(data);
            if (this._signatureSecret != null) {
                digest.update(this._signatureSecret.getBytes("UTF-8"));
            }
            return digest.digest();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DigestCredentials createCredentials(String algorithm, String user, String password, String nonce) {
        String digest = this.sign(algorithm, user, password, nonce);
        DigestCredentials cred = new DigestCredentials(user, nonce, digest);
        cred.setRealm("resin");
        return cred;
    }

    public byte[] createDigest(String user, String password, String nonce) {
        try {
            String realm = "resin";
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (user != null) {
                md.update(user.getBytes("UTF-8"));
            }
            md.update((byte)58);
            md.update(realm.getBytes("UTF-8"));
            md.update((byte)58);
            if (password != null) {
                md.update(password.getBytes("UTF-8"));
            }
            byte[] digest = md.digest();
            md.reset();
            this.updateHex(md, digest);
            md.update((byte)58);
            md.update(nonce.getBytes("UTF-8"));
            return md.digest();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void updateHex(MessageDigest md, byte[] digest) {
        for (int i = 0; i < digest.length; ++i) {
            this.updateHex(md, digest[i] >> 4);
            this.updateHex(md, digest[i]);
        }
    }

    private void updateHex(MessageDigest md, int digit) {
        if ((digit &= 0xF) < 10) {
            md.update((byte)(digit + 48));
        } else {
            md.update((byte)(digit - 10 + 97));
        }
    }

    @Override
    public int getStartPriority() {
        return 30;
    }

    @Override
    public void start() {
        Bean<Authenticator> bean;
        InjectManager cdiManager = InjectManager.getCurrent();
        if (this._authenticator == null && (bean = this.findAuthenticator(cdiManager)) != null) {
            CreationalContext<Authenticator> env = cdiManager.createCreationalContext(bean);
            this._authenticator = (Authenticator)cdiManager.getReference(bean, (Type)((Object)Authenticator.class), env);
        }
    }

    private Bean<Authenticator> findAuthenticator(InjectManager cdiManager) {
        Set beans = cdiManager.getBeans((Type)((Object)Authenticator.class), new AdminLiteral());
        if (beans.size() > 0) {
            return cdiManager.resolve(beans);
        }
        return null;
    }
}

