/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.CloudClusterAdmin;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudPodListener;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.cloud.topology.CloudSystem;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.util.L10N;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CloudCluster {
    private static final L10N L = new L10N(CloudCluster.class);
    private static final Logger log = Logger.getLogger(CloudCluster.class.getName());
    private static final int POD_INDEX_MAX = 4096;
    private final CloudSystem _domain;
    private final String _id;
    private CloudPod[] _podList = new CloudPod[0];
    private CloudClusterAdmin _admin;
    private final CopyOnWriteArrayList<CloudPodListener> _listeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<Class<?>, Object> _dataMap = new ConcurrentHashMap();

    CloudCluster(CloudSystem domain, String id) {
        this._domain = domain;
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public CloudSystem getSystem() {
        return this._domain;
    }

    public CloudPod[] getPodList() {
        return this._podList;
    }

    public ClusterMXBean getAdmin() {
        return this._admin;
    }

    void init() {
    }

    void start() {
        this._admin = new CloudClusterAdmin(this);
        this._admin.register();
    }

    void destroy() {
        if (this._admin != null) {
            this._admin.unregister();
        }
    }

    public CloudServer findServer(String id) {
        for (CloudPod pod : this._podList) {
            CloudServer server = pod.findServer(id);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public CloudServer findServerByUniqueClusterId(String id) {
        for (CloudPod pod : this._podList) {
            CloudServer server = pod.findServerByUniqueClusterId(id);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public CloudServer findServer(int podIndex, int index) {
        CloudPod pod = this.findPod(podIndex);
        if (pod != null) {
            return pod.findServer(index);
        }
        return null;
    }

    public CloudPod findPod(int podIndex) {
        CloudPod[] podList = this._podList;
        if (podIndex < podList.length) {
            return podList[podIndex];
        }
        return null;
    }

    public CloudPod findPod(String id) {
        for (CloudPod pod : this._podList) {
            if (pod == null || !id.equals(pod.getId())) continue;
            return pod;
        }
        return null;
    }

    public CloudPod createPod() {
        return this.createPod(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudPod createPod(int index) {
        CloudPod pod = null;
        CloudCluster cloudCluster = this;
        synchronized (cloudCluster) {
            if (4096 <= index) {
                throw new IllegalArgumentException(L.l("'{0}' is an invalid pod index because it's greater than the max value.", index));
            }
            if (index > 0 && index < this._podList.length && this._podList[index] != null) {
                throw new IllegalStateException(L.l("'{0}' is an invalid pod index because that pod already exists {1}", (Object)index, (Object)this._podList[index]));
            }
            for (int i = 0; i < this._podList.length; ++i) {
                CloudPod oldPod = this._podList[i];
                if (oldPod != null || index >= 0) continue;
                index = i;
            }
            if (index < 0) {
                index = this._podList.length;
            }
            pod = new CloudPod(this, null, index);
            if (this._podList.length <= index) {
                CloudPod[] podList = new CloudPod[index + 1];
                System.arraycopy(this._podList, 0, podList, 0, this._podList.length);
                this._podList = podList;
            }
            this._podList[index] = pod;
        }
        for (CloudPodListener listener : this._listeners) {
            listener.onPodAdd(pod);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(this + " added " + pod);
        }
        return pod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePod(int index) {
        if (index < 0 || this._podList.length <= index) {
            return false;
        }
        CloudPod pod = null;
        CloudCluster cloudCluster = this;
        synchronized (cloudCluster) {
            int tail;
            pod = this._podList[index];
            if (pod == null) {
                return false;
            }
            for (CloudServer server : pod.getServerList()) {
                if (server == null) continue;
                throw new IllegalStateException(L.l("{0} may not be removed because it has a non-empty server list", (Object)pod));
            }
            this._podList[index] = null;
            for (tail = this._podList.length - 1; tail >= 0 && this._podList[tail] == null; --tail) {
            }
            if (tail + 1 < this._podList.length) {
                CloudPod[] podArray = new CloudPod[tail + 1];
                System.arraycopy(this._podList, 0, podArray, 0, tail + 1);
                this._podList = podArray;
            }
        }
        for (CloudPodListener listener : this._listeners) {
            listener.onPodRemove(pod);
        }
        return true;
    }

    public CloudServer findServer(String address, int port) {
        for (CloudPod pod : this._podList) {
            CloudServer server = pod.findServer(address, port);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public void putData(Object value) {
        this._dataMap.put(value.getClass(), value);
    }

    public <T> T putDataIfAbsent(T value) {
        return (T)this._dataMap.putIfAbsent(value.getClass(), value);
    }

    public <T> T getData(Class<T> cl) {
        return (T)this._dataMap.get(cl);
    }

    public void addPodListener(CloudPodListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
        for (CloudPod pod : this.getPodList()) {
            listener.onPodAdd(pod);
        }
    }

    public void removePodListener(CloudPodListener listener) {
        this._listeners.remove(listener);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

