/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.topology.CloudCluster;
import com.caucho.cloud.topology.CloudPod;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.management.server.ClusterServerMXBean;
import com.caucho.management.server.HostMXBean;
import com.caucho.management.server.PersistentStoreMXBean;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.ResinMXBean;
import com.caucho.server.resin.Resin;
import java.util.ArrayList;

public class CloudClusterAdmin
extends AbstractManagedObject
implements ClusterMXBean {
    private final CloudCluster _cluster;
    private ResinMXBean _resinAdmin;

    public CloudClusterAdmin(CloudCluster cluster) {
        this._cluster = cluster;
        Resin resin = Resin.getCurrent();
        if (resin != null) {
            this._resinAdmin = resin.getAdmin();
        }
    }

    @Override
    public String getName() {
        return this._cluster.getId();
    }

    @Override
    public HostMXBean[] getHosts() {
        return new HostMXBean[0];
    }

    public PortMXBean getPort() {
        return null;
    }

    @Override
    public ResinMXBean getResin() {
        if (this._resinAdmin == null && Resin.getCurrent() != null) {
            this._resinAdmin = Resin.getCurrent().getAdmin();
        }
        return this._resinAdmin;
    }

    @Override
    public PersistentStoreMXBean getPersistentStore() {
        return null;
    }

    @Override
    public ClusterServerMXBean[] getServers() {
        ArrayList<ClusterServerMXBean> serverMBeansList = new ArrayList<ClusterServerMXBean>();
        for (CloudPod pod : this._cluster.getPodList()) {
            for (CloudServer server : pod.getServerList()) {
                ClusterServer clusterServer;
                if (server == null || (clusterServer = server.getData(ClusterServer.class)) == null) continue;
                serverMBeansList.add(clusterServer.getAdmin());
            }
        }
        ClusterServerMXBean[] serverMBeans = new ClusterServerMXBean[serverMBeansList.size()];
        serverMBeansList.toArray(serverMBeans);
        return serverMBeans;
    }

    @Override
    public void addDynamicServer(String id, String address, int port) {
    }

    @Override
    public boolean isDynamicServerEnable() {
        return false;
    }

    void register() {
        this.registerSelf();
    }

    void unregister() {
        this.unregisterSelf();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

