/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.TagName;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.inject.Module;
import com.caucho.loader.EnvironmentBean;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Stereotype;

@Module
public class BeansConfig
implements EnvironmentBean {
    private static final L10N L = new L10N(BeansConfig.class);
    private InjectManager _injectManager;
    private Path _root;
    private Path _beansFile;
    private ArrayList<Class<?>> _alternativesList = new ArrayList();
    private ArrayList<Class<?>> _interceptorList = new ArrayList();
    private ArrayList<Class<?>> _decoratorList = new ArrayList();
    private ArrayList<Class<?>> _pendingClasses = new ArrayList();
    private boolean _isConfigured;

    public BeansConfig(InjectManager injectManager, Path root) {
        this._injectManager = injectManager;
        this._root = root;
        this._beansFile = root.lookup("META-INF/beans.xml");
        this._beansFile.setUserPath(this._beansFile.getURL());
    }

    public void setSchemaLocation(String schema) {
    }

    public void setVersion(String version) {
    }

    public void setBeanDiscoveryMode(String version) {
    }

    public InjectManager getContainer() {
        return this._injectManager;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.getContainer().getClassLoader();
    }

    public Path getRoot() {
        return this._root;
    }

    public void addScannedClass(Class<?> cl) {
        this._pendingClasses.add(cl);
    }

    public boolean isConfigured() {
        return this._isConfigured;
    }

    public void setConfigured(boolean isConfigured) {
        this._isConfigured = isConfigured;
    }

    public ArrayList<Class<?>> getAlternativesList() {
        return this._alternativesList;
    }

    public void addCustomBean(XmlBeanConfig<?> bean) {
    }

    @TagName(value={"Deploy"})
    public DeployConfig createDeploy() {
        return new DeployConfig();
    }

    public AlternativesConfig createAlternatives() {
        return new AlternativesConfig();
    }

    public Interceptors createInterceptors() {
        return new Interceptors();
    }

    public Decorators createDecorators() {
        return new Decorators();
    }

    @PostConstruct
    public void init() {
        for (Class<?> cl : this._decoratorList) {
            this._injectManager.addDecoratorClass(cl);
        }
        this._decoratorList.clear();
        for (Class<?> cl : this._interceptorList) {
            this._injectManager.addInterceptorClass(cl);
        }
        this._interceptorList.clear();
        this.update();
    }

    public void update() {
        InjectManager injectManager = this._injectManager;
        try {
            if (this._pendingClasses.size() > 0) {
                ArrayList pendingClasses = new ArrayList(this._pendingClasses);
                this._pendingClasses.clear();
                for (Class<?> cl : pendingClasses) {
                    ManagedBeanImpl<?> bean = injectManager.createManagedBean(cl);
                    injectManager.addBeanDiscover(bean);
                    bean.introspectProduces();
                }
            }
        }
        catch (Exception e) {
            throw LineConfigException.create(this._beansFile.getURL(), 1, (Throwable)e);
        }
    }

    public <T> void addInterceptor(Class<T> cl) {
        if (this._interceptorList == null) {
            this._interceptorList = new ArrayList();
        }
        if (cl.isInterface()) {
            throw new ConfigException(L.l("'{0}' is not valid because <interceptors> can only contain interceptor implementations", (Object)cl.getName()));
        }
        if (this._interceptorList.contains(cl)) {
            throw new ConfigException(L.l("'{0}' is a duplicate interceptor. Interceptors may not be listed twice in the beans.xml", (Object)cl.getName()));
        }
        this._interceptorList.add(cl);
    }

    public String toString() {
        if (this._root != null) {
            return this.getClass().getSimpleName() + "[" + this._root.getURL() + "]";
        }
        return this.getClass().getSimpleName() + "[]";
    }

    public class AlternativesConfig {
        public void addClass(Class<?> cl) {
            if (cl.isAnnotation() && !cl.isAnnotationPresent(Stereotype.class)) {
                throw new ConfigException(L.l("'{0}' is an invalid alternative because it is an annotation.", (Object)cl.getName()));
            }
            if (!cl.isAnnotationPresent(Alternative.class)) {
                throw new ConfigException(L.l("'{0}' is an invalid alternative because it does not have an @Alternative annotation.", (Object)cl.getName()));
            }
            if (BeansConfig.this._alternativesList.contains(cl)) {
                throw new ConfigException(L.l("'{0}' is an invalid alternative because it is listed twice.", (Object)cl.getName()));
            }
            BeansConfig.this._alternativesList.add(cl);
        }

        public void addStereotype(Class<?> cl) {
            if (!cl.isAnnotation()) {
                throw new ConfigException(L.l("'{0}' is an invalid alternative because it is not an annotation.", (Object)cl.getName()));
            }
            if (!cl.isAnnotationPresent(Alternative.class)) {
                throw new ConfigException(L.l("'{0}' is an invalid alternative because it is missing an @Alternative.", (Object)cl.getName()));
            }
            BeansConfig.this._alternativesList.add(cl);
        }
    }

    public class DeployConfig {
        public void setConfigLocation(String location) {
        }

        public void addAnnotation(Annotation ann) {
            Class<? extends Annotation> cl = ann.annotationType();
            BeansConfig.this._alternativesList.add(cl);
        }
    }

    public class Decorators {
        public void setConfigLocation(String location) {
        }

        public void addClass(Class<?> cl) {
            if (BeansConfig.this._decoratorList.contains(cl)) {
                throw new ConfigException(L.l("'{0}' is a duplicate decorator. Decorators may not be listed twice in the beans.xml", (Object)cl.getName()));
            }
            BeansConfig.this._decoratorList.add(cl);
        }

        public void addDecorator(Class<?> cl) {
            this.addClass(cl);
        }

        public void addCustomBean(XmlBeanConfig<?> config) {
            Class<?> cl = config.getClassType();
            if (cl.isInterface()) {
                throw new ConfigException(L.l("'{0}' is not valid because <Decorators> can only contain decorator implementations", (Object)cl.getName()));
            }
            BeansConfig.this._decoratorList.add(cl);
        }
    }

    public class Interceptors {
        public void addClass(Class<?> cl) {
            BeansConfig.this.addInterceptor(cl);
        }
    }
}

