/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.event;

import com.caucho.config.ConfigException;
import com.caucho.config.LineConfigException;
import com.caucho.config.event.AbstractObserverMethod;
import com.caucho.config.inject.InjectManager;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.inject.spi.Bean;

public class ObserverImpl<X, T>
extends AbstractObserverMethod<T> {
    private static final L10N L = new L10N(ObserverImpl.class);
    private static final Object[] NULL_ARGS = new Object[0];
    private final InjectManager _inject;
    private final Bean<X> _bean;
    private final Method _method;
    private final int _paramIndex;
    private boolean _hasBinding;
    private boolean _ifExists;
    private Bean<?>[] _args;

    public ObserverImpl(InjectManager webBeans, Bean<X> bean, Method method, int paramIndex) {
        this._inject = webBeans;
        this._bean = bean;
        this._method = method;
        this._method.setAccessible(true);
        this._paramIndex = paramIndex;
        for (Annotation ann : method.getParameterAnnotations()[paramIndex]) {
            if (!(ann instanceof Observes)) continue;
            Observes observes = (Observes)ann;
            this._ifExists = observes.notifyObserver() == Reception.IF_EXISTS;
        }
        this.bind();
    }

    public Class<?> getType() {
        return this._method.getParameterTypes()[this._paramIndex];
    }

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind() {
        ObserverImpl observerImpl = this;
        synchronized (observerImpl) {
            if (this._args != null) {
                return;
            }
            Type[] param = this._method.getGenericParameterTypes();
            Annotation[][] annList = this._method.getParameterAnnotations();
            this._args = new Bean[param.length];
            String loc = LineConfigException.loc(this._method);
            for (int i = 0; i < param.length; ++i) {
                if (this.hasObserves(annList[i])) continue;
                Set<Bean<?>> beans = this._inject.getBeans(param[i], annList[i]);
                if (beans == null || beans.size() == 0) {
                    throw new ConfigException(loc + L.l("Parameter '{0}' binding does not have a matching component", (Object)ObserverImpl.getSimpleName(param[i])));
                }
                Bean<?> comp = null;
                Iterator<Bean<?>> iter = beans.iterator();
                if (iter.hasNext()) {
                    comp = iter.next();
                }
                this._args[i] = comp;
            }
        }
    }

    private boolean hasObserves(Annotation[] annList) {
        for (Annotation ann : annList) {
            if (!(ann instanceof Observes)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void notify(Object event) {
        Object obj = null;
        if (this._ifExists) {
            Context context = this._inject.getContext(this._bean.getScope());
            if (context != null && context.isActive()) {
                obj = context.get(this._bean);
            }
        } else {
            CreationalContext<X> env = this._inject.createCreationalContext(this._bean);
            obj = this._inject.getReference(this._bean, this._bean.getBeanClass(), env);
        }
        try {
            if (obj != null) {
                Object[] args = new Object[this._args.length];
                for (int i = 0; i < this._args.length; ++i) {
                    Bean<?> bean = this._args[i];
                    if (bean != null) {
                        CreationalContext<?> env = this._inject.createCreationalContext(bean);
                        args[i] = this._inject.getReference(bean, bean.getBeanClass(), env);
                        continue;
                    }
                    args[i] = event;
                }
                this._method.invoke(obj, args);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ObserverImpl)) {
            return false;
        }
        ObserverImpl comp = (ObserverImpl)obj;
        return this._bean.equals(comp._bean);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this._method.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(this._method.getName());
        sb.append("[");
        sb.append(this._method.getParameterTypes()[this._paramIndex].getSimpleName());
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }

    protected static String getSimpleName(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getSimpleName();
        }
        return String.valueOf(type);
    }
}

