/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.AspectGeneratorUtil;
import com.caucho.config.gen.AsynchronousFactory;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

@Module
public class AsyncHeadGenerator<X>
extends AbstractAspectGenerator<X> {
    public AsyncHeadGenerator(AsynchronousFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next) {
        super(factory, method, next);
    }

    protected boolean isOverride() {
        return false;
    }

    @Override
    public final void generate(JavaWriter out, HashMap<String, Object> prologueMap) throws IOException {
        this.generateMethodPrologue(out, prologueMap);
        String prefix = "";
        String suffix = "_async";
        String methodName = prefix + this.getJavaMethod().getName() + suffix;
        AspectGeneratorUtil.generateHeader(out, this.isOverride(), "public", methodName, this.getMethod(), this.getTypeVariables(), this.getThrowsExceptions());
        out.println("{");
        out.pushDepth();
        this.generateContent(out, prologueMap);
        out.popDepth();
        out.println("}");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsyncHeadGenerator)) {
            return false;
        }
        AsyncHeadGenerator bizMethod = (AsyncHeadGenerator)o;
        return AnnotatedTypeUtil.isMatch(this.getJavaMethod(), bizMethod.getJavaMethod());
    }
}

