/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ValueGenerator;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JndiValueGenerator
extends ValueGenerator {
    private static final Logger log = Logger.getLogger(JndiValueGenerator.class.getName());
    private static final L10N L = new L10N(JndiValueGenerator.class);
    private final String _location;
    private final String _jndiName;
    private final Class<?> _type;

    public JndiValueGenerator(String location, Class<?> type, String jndiName) {
        this._location = location;
        this._type = type;
        this._jndiName = jndiName;
        if (this._jndiName == null || "".equals(this._jndiName)) {
            throw new IllegalArgumentException(L.l("JNDI name cannot be empty"));
        }
    }

    @Override
    public Object create() throws ConfigException {
        try {
            return new InitialContext().lookup(this._jndiName);
        }
        catch (NamingException e) {
            throw ConfigException.create(this._location, (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jndiName + "," + this._type + "]";
    }
}

