/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.program;

import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ResourceInjectionTargetProgram;
import com.caucho.util.FreeList;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class ResourceProgramManager {
    private final ConcurrentHashMap<Class<?>, ArrayList<ResourceInjectionTargetProgram>> _programMap = new ConcurrentHashMap();
    private final FreeList<TargetKey> _freeList = new FreeList(16);

    public void addResource(ResourceInjectionTargetProgram resource) {
        ArrayList<ResourceInjectionTargetProgram> programList = this._programMap.get(resource.getTargetClass());
        if (programList == null) {
            programList = new ArrayList();
            this._programMap.put(resource.getTargetClass(), programList);
        }
        programList.add(resource);
    }

    public void buildInject(Class<?> type, ArrayList<ConfigProgram> injectProgramList) {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        this.buildInject(type.getSuperclass(), injectProgramList);
        ArrayList<ResourceInjectionTargetProgram> programList = this._programMap.get(type);
        if (programList == null) {
            return;
        }
        for (ResourceInjectionTargetProgram program : programList) {
            injectProgramList.add(program);
        }
    }

    static class TargetKey {
        private Class<?> _targetClass;
        private String _targetName;

        TargetKey() {
        }

        TargetKey(Class<?> targetClass, String targetName) {
            this._targetClass = targetClass;
            this._targetName = targetName;
        }

        public void init(Class<?> targetClass, String targetName) {
            this._targetClass = targetClass;
            this._targetName = targetName;
        }

        public int hashCode() {
            return 65521 * this._targetClass.hashCode() + this._targetName.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TargetKey)) {
                return false;
            }
            TargetKey key = (TargetKey)o;
            return this._targetClass.equals(key._targetClass) && this._targetName.equals(key._targetName);
        }
    }
}

