/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.ClassType;
import com.caucho.config.reflect.ReflectionAnnotatedType;
import com.caucho.config.reflect.ReflectionSimpleAnnotatedType;
import com.caucho.loader.EnvironmentLocal;
import java.lang.ref.SoftReference;
import java.lang.reflect.Type;
import java.util.WeakHashMap;

public class ReflectionAnnotatedFactory {
    private static EnvironmentLocal<ReflectionAnnotatedFactory> _current = new EnvironmentLocal();
    private WeakHashMap<Type, SoftReference<ReflectionSimpleAnnotatedType<?>>> _simpleTypeMap = new WeakHashMap();
    private WeakHashMap<Type, SoftReference<ReflectionAnnotatedType<?>>> _typeMap = new WeakHashMap();

    private ReflectionAnnotatedFactory(ClassLoader loader) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReflectionAnnotatedFactory create(ClassLoader loader) {
        EnvironmentLocal<ReflectionAnnotatedFactory> environmentLocal = _current;
        synchronized (environmentLocal) {
            ReflectionAnnotatedFactory factory = _current.getLevel(loader);
            if (factory == null) {
                factory = new ReflectionAnnotatedFactory(loader);
                _current.set(factory, loader);
            }
            return factory;
        }
    }

    public static <T> ReflectionSimpleAnnotatedType<T> introspectSimpleType(Class<T> cl) {
        return ReflectionAnnotatedFactory.create(cl.getClassLoader()).introspectSimpleTypeImpl(cl);
    }

    private synchronized <T> ReflectionSimpleAnnotatedType<T> introspectSimpleTypeImpl(Type type) {
        SoftReference<ReflectionSimpleAnnotatedType<?>> typeRef = this._simpleTypeMap.get(type);
        ReflectionSimpleAnnotatedType<Object> annType = null;
        if (typeRef != null) {
            annType = typeRef.get();
        }
        if (annType == null) {
            InjectManager inject = InjectManager.create();
            BaseType baseType = inject.createSourceBaseType(type);
            annType = new ReflectionSimpleAnnotatedType(inject, baseType);
            typeRef = new SoftReference(annType);
            this._simpleTypeMap.put(type, typeRef);
        }
        return annType;
    }

    public static <X> ReflectionAnnotatedType<X> introspectType(Class<X> cl) {
        return ReflectionAnnotatedFactory.create(cl.getClassLoader()).introspectTypeImpl(cl);
    }

    public static <X> ReflectionAnnotatedType<X> introspectType(BaseType type) {
        ClassLoader loader = type instanceof ClassType ? type.getRawClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
        return ReflectionAnnotatedFactory.create(loader).introspectTypeImpl(type);
    }

    private synchronized <X> ReflectionAnnotatedType<X> introspectTypeImpl(Type type) {
        SoftReference<ReflectionAnnotatedType<?>> typeRef = this._typeMap.get(type);
        ReflectionAnnotatedType<Object> annType = null;
        if (typeRef != null) {
            annType = typeRef.get();
        }
        if (annType == null) {
            InjectManager inject = InjectManager.create();
            BaseType baseType = inject.createSourceBaseType(type);
            annType = new ReflectionAnnotatedType(inject, baseType);
            typeRef = new SoftReference(annType);
            this._typeMap.put(type, typeRef);
        }
        return annType;
    }

    private synchronized <X> ReflectionAnnotatedType<X> introspectTypeImpl(BaseType baseType) {
        Type type = baseType.toType();
        SoftReference<ReflectionAnnotatedType<?>> typeRef = this._typeMap.get(type);
        ReflectionAnnotatedType<Object> annType = null;
        if (typeRef != null) {
            annType = typeRef.get();
        }
        if (annType == null) {
            InjectManager inject = InjectManager.create();
            annType = new ReflectionAnnotatedType(inject, baseType);
            typeRef = new SoftReference(annType);
            this._typeMap.put(type, typeRef);
        }
        return annType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

