/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class ShortType
extends ConfigType {
    private static final L10N L = new L10N(ShortType.class);
    public static final ShortType TYPE = new ShortType();
    private static final Short ZERO = new Short(0);

    private ShortType() {
    }

    public Class getType() {
        return Short.class;
    }

    @Override
    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        return Short.valueOf(text);
    }

    @Override
    public Object valueOf(Object value) {
        if (value instanceof Short) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Short(((Number)value).shortValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to a Short", value));
    }
}

