/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.types.RawString;
import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.el.MapVariableResolver;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;

public class PathBuilder {
    private String _userPath;

    public void addText(RawString text) {
        this._userPath = text.getValue().trim();
    }

    public Path replaceObject() throws ELException {
        return PathBuilder.lookupPath(this._userPath, Config.getEnvironment());
    }

    public static Path lookupPath(String string) throws ELException {
        return PathBuilder.lookupPath(string, Config.getEnvironment());
    }

    public static Path lookupPath(String string, ArrayList<?> vars) throws ELException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regexp", vars);
        return PathBuilder.lookupPath(string, map);
    }

    public static Path lookupPath(String string, Map<String, Object> map) throws ELException {
        ConfigELContext context;
        if (map != null) {
            MapVariableResolver resolver = new MapVariableResolver(map);
            context = new ConfigELContext(resolver);
        } else {
            context = new ConfigELContext();
        }
        return PathBuilder.lookupPath(string, context);
    }

    public static Path lookupPath(String string, ELContext env) throws ELException {
        return PathBuilder.lookupPath(string, env, Vfs.lookup());
    }

    public static Path lookupPath(String string, ELContext env, Path pwd) throws ELException {
        Expr expr;
        Object obj;
        if (env == null) {
            env = Config.getEnvironment();
        }
        if ((obj = (expr = new ELParser(env, string = PathBuilder.rewritePathString(string)).parse()).evalObject(env)) instanceof Path) {
            return (Path)obj;
        }
        String value = Expr.toString(obj, env);
        if (pwd != null) {
            return pwd.lookup(value);
        }
        return Vfs.lookup(value);
    }

    public static String rewritePathString(String pathName) {
        StringBuilder cb = new StringBuilder();
        int length = pathName.length();
        for (int i = 0; i < length; ++i) {
            char ch = pathName.charAt(i);
            if (ch != '$') {
                cb.append(ch);
                continue;
            }
            if (i + 1 == length) {
                cb.append('$');
                continue;
            }
            ch = pathName.charAt(i + 1);
            if ('0' <= ch && ch <= '9') {
                int value = 0;
                ++i;
                while (i < length && (ch = pathName.charAt(i)) >= '0' && ch <= '9') {
                    value = 10 * value + ch - 48;
                    ++i;
                }
                --i;
                cb.append("${regexp[" + value + "]}");
                continue;
            }
            if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z') {
                int tail;
                for (tail = i + 1; tail < length && (ch = pathName.charAt(tail)) != '/' && ch != '\\' && ch != '$'; ++tail) {
                }
                cb.append("${" + pathName.substring(i + 1, tail) + "}");
                i = tail - 1;
                continue;
            }
            cb.append('$');
        }
        return cb.toString();
    }
}

