/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.annotation.Annotation;

public class XmlBeanAnnotationAttribute<T>
extends Attribute {
    private static final L10N L = new L10N(XmlBeanAnnotationAttribute.class);
    private static final QName VALUE = new QName("value");
    private final ConfigType<T> _configType;

    public XmlBeanAnnotationAttribute(Class<T> cl) {
        this._configType = TypeFactory.getType(cl);
    }

    public ConfigType<T> getConfigType() {
        return this._configType;
    }

    @Override
    public Object create(Object parent, QName qName) throws ConfigException {
        return this._configType.create(parent, qName);
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        XmlBeanConfig customBean = (XmlBeanConfig)bean;
        if (value instanceof Annotation) {
            customBean.addAnnotation((Annotation)value);
        } else {
            AnnotationConfig annConfig = (AnnotationConfig)value;
            customBean.addAnnotation(annConfig.replace());
        }
    }

    @Override
    public void setText(Object parent, QName name, String text) throws ConfigException {
        Object bean = this.create(parent, name);
        Attribute attr = this._configType.getAttribute(VALUE);
        if (attr != null) {
            attr.setText(bean, VALUE, text);
            this.setValue(parent, name, bean);
        } else if (text == null || "".equals(text)) {
            this.setValue(parent, name, bean);
        } else {
            throw new ConfigException(L.l("'{0}' does not have a 'value' attribute, so it cannot have a text value.", (Object)name));
        }
    }
}

