/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.AddAttribute;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.attribute.FlowAttribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.xml.XmlBeanAddAttribute;
import com.caucho.config.xml.XmlBeanAnnotationAttribute;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.config.xml.XmlBeanFieldAttribute;
import com.caucho.config.xml.XmlBeanMethodAttribute;
import com.caucho.config.xml.XmlBeanNewAttribute;
import com.caucho.config.xml.XmlBeanProgramAttribute;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import com.caucho.xml.QNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class XmlBeanType<T>
extends ConfigType<T> {
    private static final L10N L = new L10N(XmlBeanType.class);
    private static final Logger log = Logger.getLogger(XmlBeanType.class.getName());
    private static final String RESIN_NS = "http://caucho.com/ns/resin";
    private static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee";
    private static final QName TEXT = new QName("#text");
    private static final QName W_VALUE = new QName("", "value", "http://java.sun.com/xml/ns/javaee");
    private static final QName R_VALUE = new QName("", "value", "http://caucho.com/ns/resin");
    private static final QName A_VALUE = new QName("value", null);
    private static final QName W_NEW = new QName("", "new", "http://java.sun.com/xml/ns/javaee");
    private static final QName R_NEW = new QName("", "new", "http://caucho.com/ns/resin");
    private static final QName A_NEW = new QName("new", null);
    private final Class<T> _beanClass;
    private final ConfigType<T> _beanType;
    private String _namespaceURI;
    private HashMap<QName, Attribute> _nsAttributeMap = new HashMap();

    public XmlBeanType(Class<T> beanClass) {
        this._beanClass = beanClass;
        this._beanType = TypeFactory.getType(beanClass);
        int p = beanClass.getName().lastIndexOf(46);
        this._namespaceURI = "urn:java:" + beanClass.getName().substring(0, p);
        this._nsAttributeMap.put(W_NEW, XmlBeanNewAttribute.ATTRIBUTE);
        this._nsAttributeMap.put(R_NEW, XmlBeanNewAttribute.ATTRIBUTE);
        this._nsAttributeMap.put(A_NEW, XmlBeanNewAttribute.ATTRIBUTE);
    }

    @Override
    public Class<T> getType() {
        return this._beanClass;
    }

    @Override
    public Object create(Object parent, QName name) {
        return new XmlBeanConfig<T>(name, this._beanClass, null);
    }

    @Override
    public Attribute getAttribute(QName qName) {
        Attribute attr = this._nsAttributeMap.get(qName);
        if (attr == null && (attr = this.getAttributeImpl(qName)) != null) {
            this._nsAttributeMap.put(qName, attr);
        }
        return attr;
    }

    protected Attribute getAttributeImpl(QName qName) {
        Attribute attr = this._beanType.getAttribute(qName);
        if (attr != null) {
            return XmlBeanProgramAttribute.ATTRIBUTE;
        }
        String uri = qName.getNamespaceURI();
        if (uri == null) {
            return null;
        }
        if (!uri.startsWith("urn:java:") && !uri.equals(RESIN_NS)) {
            return null;
        }
        Method method = null;
        if (uri.equals(this._namespaceURI) && (method = this.findMethod(qName.getLocalName())) != null) {
            return new XmlBeanMethodAttribute(this._beanClass, method);
        }
        Field field = null;
        if (uri.equals(this._namespaceURI) && (field = this.findField(qName.getLocalName())) != null) {
            return new XmlBeanFieldAttribute(this._beanClass, field);
        }
        if ("new".equals(qName.getLocalName())) {
            return XmlBeanNewAttribute.ATTRIBUTE;
        }
        Attribute envAttr = TypeFactory.getFactory().getEnvironmentAttribute(qName);
        if (envAttr instanceof FlowAttribute) {
            return envAttr;
        }
        ConfigType<?> type = TypeFactory.getFactory().getEnvironmentType(qName);
        if (type == null) {
            if (Character.isLowerCase(qName.getLocalName().charAt(0))) {
                throw new ConfigException(L.l("'{0}' is an unknown field of {1}", (Object)qName.getLocalName(), (Object)this._beanClass.getName()));
            }
            throw new ConfigException(L.l("'{0}' cannot be instantiated because it does not map to a known class", (Object)qName));
        }
        Class<?> cl = type.getType();
        if (Annotation.class.isAssignableFrom(cl)) {
            return new XmlBeanAnnotationAttribute(cl);
        }
        AddAttribute addAttribute = (AddAttribute)this._beanType.getAddAttribute(cl);
        if (addAttribute != null) {
            return new XmlBeanAddAttribute(cl);
        }
        throw new ConfigException(L.l("'{0}' is an unknown field or annotation", (Object)qName));
    }

    @Override
    public Attribute getProgramAttribute() {
        Attribute attr = this._beanType.getProgramAttribute();
        if (attr == null) {
            return null;
        }
        return XmlBeanProgramAttribute.ATTRIBUTE;
    }

    private Method findMethod(String name) {
        return this.findMethod(this._beanClass, name);
    }

    private Method findMethod(Class<?> cl, String name) {
        if (cl == null || cl.equals(Object.class)) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return this.findMethod(cl.getSuperclass(), name);
    }

    private Field findField(String name) {
        return this.findField(this._beanClass, name);
    }

    private Field findField(Class<?> cl, String name) {
        if (cl == null || cl.equals(Object.class)) {
            return null;
        }
        for (Field field : cl.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return this.findField(cl.getSuperclass(), name);
    }

    private ConfigType createClass(QName name) {
        return TypeFactory.getFactory().getEnvironmentType(name);
    }

    private Class<?> createResinClass(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> cl = TypeFactory.loadClass("ee", name);
        return cl;
    }

    @Override
    public void beforeConfigure(XmlConfigContext builder, Object bean, Node node) {
        super.beforeConfigure(builder, bean, node);
        if (bean instanceof XmlBeanConfig) {
            XmlBeanConfig xmlBean = (XmlBeanConfig)bean;
            if (node instanceof QNode) {
                QNode qNode = (QNode)node;
                String uri = qNode.getBaseURI();
                int line = qNode.getLine();
                xmlBean.setConfigLocation(uri, line);
            }
        }
    }

    @Override
    public Object valueOf(String text) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void init(Object bean) {
        XmlBeanConfig customBean = (XmlBeanConfig)bean;
        customBean.init();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._beanClass.getName() + "]";
    }
}

