/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.lock;

import com.caucho.db.lock.LockTimeoutException;
import com.caucho.util.CurrentTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public final class DatabaseLock
implements ReadWriteLock {
    private static final AtomicLongFieldUpdater<DatabaseLock> _lockCountUpdater = AtomicLongFieldUpdater.newUpdater(DatabaseLock.class, "_lockCount");
    private static final long LOCK_WRITE = 0x1000000000000000L;
    private static final long LOCK_WRITE_MASK = 0x1000000000000000L;
    private static final long LOCK_WRITE_WAIT = 0x10000000000L;
    private static final long LOCK_WRITE_WAIT_MASK = 0xFFFFF0000000000L;
    private static final long LOCK_READ_WAIT = 0x100000L;
    private static final long LOCK_READ_WAIT_MASK = 0xFFFFF00000L;
    private static final long LOCK_READ = 1L;
    private static final long LOCK_READ_MASK = 1048575L;
    private static final long LOCK_MASK = 0x10000000000FFFFFL;
    private static final long LOCK_WAIT_MASK = 0xFFFFFFFFFF00000L;
    private final Lock _readLock = new ReadLockImpl();
    private final Lock _writeLock = new WriteLockImpl();
    private volatile long _lockCount;

    public DatabaseLock(String id) {
    }

    @Override
    public Lock readLock() {
        return this._readLock;
    }

    @Override
    public Lock writeLock() {
        return this._writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockRead(long timeout) throws LockTimeoutException {
        if (this.lockReadCounter()) {
            return;
        }
        long expires = CurrentTime.getCurrentTimeActual() + timeout;
        boolean isValid = false;
        try {
            this.lockReadWait(expires);
            isValid = true;
        }
        finally {
            if (!isValid) {
                this.unlockReadWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockWrite(long timeout) {
        if (this.lockWriteCounter()) {
            return;
        }
        long expires = CurrentTime.getCurrentTimeActual() + timeout;
        boolean isValid = false;
        try {
            this.lockWriteWait(expires);
            isValid = true;
        }
        finally {
            if (!isValid) {
                this.unlockWriteWait();
            }
        }
    }

    public void unlockRead() {
        this.unlockReadCounter();
    }

    public void unlockWrite() {
        this.unlockWriteCounter();
    }

    private boolean lockReadCounter() {
        boolean isQuickLock;
        long newLock;
        long lock;
        while (!_lockCountUpdater.compareAndSet(this, lock, newLock = (isQuickLock = DatabaseLock.isLockCanReadQuick(lock = this._lockCount)) ? lock + 1L : lock + 0x100000L)) {
        }
        return isQuickLock;
    }

    private boolean lockWriteCounter() {
        boolean isQuickLock;
        long newLock;
        long lock;
        while (!_lockCountUpdater.compareAndSet(this, lock, newLock = (isQuickLock = DatabaseLock.isLockCanWriteQuick(lock = this._lockCount)) ? lock + 0x1000000000000000L : lock + 0x10000000000L)) {
        }
        return isQuickLock;
    }

    private void unlockReadWait() {
        long newLock;
        long lock;
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, newLock = lock - 0x100000L)) {
        }
    }

    private void unlockWriteWait() {
        long newLock;
        long lock;
        while (!_lockCountUpdater.compareAndSet(this, lock = this._lockCount, newLock = lock - 0x10000000000L)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockReadCounter() {
        boolean isWaiter;
        long newLock;
        long lock;
        do {
            boolean bl = isWaiter = ((lock = this._lockCount) & 0xFFFFFFFFFF00000L) != 0L;
        } while (!_lockCountUpdater.compareAndSet(this, lock, newLock = lock - 1L));
        if (isWaiter) {
            DatabaseLock databaseLock = this;
            synchronized (databaseLock) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockWriteCounter() {
        boolean isWaiter;
        long newLock;
        long lock;
        do {
            boolean bl = isWaiter = ((lock = this._lockCount) & 0xFFFFFFFFFF00000L) != 0L;
        } while (!_lockCountUpdater.compareAndSet(this, lock, newLock = lock - 0x1000000000000000L));
        if (isWaiter) {
            DatabaseLock databaseLock = this;
            synchronized (databaseLock) {
                this.notify();
            }
        }
    }

    private void lockReadWait(long expires) {
        DatabaseLock databaseLock = this;
        synchronized (databaseLock) {
            block5: while (true) {
                while (true) {
                    long lock;
                    if (DatabaseLock.isLockCanRead(lock = this._lockCount)) {
                        long newLock = lock + 1L - 0x100000L;
                        if (!_lockCountUpdater.compareAndSet(this, lock, newLock)) continue;
                        return;
                    }
                    long delta = expires - CurrentTime.getCurrentTimeActual();
                    if (delta <= 0L) {
                        throw new LockTimeoutException();
                    }
                    try {
                        this.wait(delta);
                        continue block5;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void lockWriteWait(long expires) {
        DatabaseLock databaseLock = this;
        synchronized (databaseLock) {
            block5: while (true) {
                while (true) {
                    long lock;
                    if (DatabaseLock.isLockCanWrite(lock = this._lockCount)) {
                        long newLock = lock + 0x1000000000000000L - 0x10000000000L;
                        if (!_lockCountUpdater.compareAndSet(this, lock, newLock)) continue;
                        return;
                    }
                    long delta = expires - CurrentTime.getCurrentTimeActual();
                    if (delta <= 0L) {
                        throw new LockTimeoutException("write timeout 0x" + Long.toHexString(lock));
                    }
                    try {
                        this.wait(delta);
                        continue block5;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private static boolean isLockCanRead(long lock) {
        return (lock & 0x10000000000FFFFFL) == 0L || (lock & 0x1FFFFF0000000000L) == 0L;
    }

    private static boolean isLockCanWrite(long lock) {
        return (lock & 0x10000000000FFFFFL) == 0L;
    }

    private static boolean isLockCanReadQuick(long lock) {
        return (lock & 0x10000000000FFFFFL) == 0L || (lock & 0x1FFFFF0000000000L) == 0L;
    }

    private static boolean isLockCanWriteQuick(long lock) {
        return lock == 0L;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    class WriteLockImpl
    implements Lock {
        WriteLockImpl() {
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            DatabaseLock.this.lockWrite(unit.toMillis(time));
            return true;
        }

        @Override
        public void unlock() {
            DatabaseLock.this.unlockWrite();
        }

        @Override
        public void lock() {
            try {
                if (!this.tryLock(0x3FFFFFFFFFFFFFFFL, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(0x3FFFFFFFFFFFFFFFL, TimeUnit.MILLISECONDS);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException(this.getClass().getName());
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    final class ReadLockImpl
    implements Lock {
        ReadLockImpl() {
        }

        @Override
        public final boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            DatabaseLock.this.lockRead(unit.toMillis(timeout));
            return true;
        }

        @Override
        public final void unlock() {
            DatabaseLock.this.unlockRead();
        }

        @Override
        public final void lock() {
            try {
                if (!this.tryLock(0x3FFFFFFFFFFFFFFFL, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(0x3FFFFFFFFFFFFFFFL, TimeUnit.MILLISECONDS);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException(this.getClass().getName());
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException(this.getClass().getName());
        }
    }

    static enum LockType {
        READ,
        WRITE;

    }
}

