/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import java.sql.SQLException;

final class ColumnExpr
extends Expr {
    private final Table _table;
    private final int _tableIndex;
    private final Column _column;
    private final int _columnIndex;
    private final String _name;
    private final Class<?> _type;

    ColumnExpr(String name, Table table, int tableIndex, int columnIndex, Class<?> type) {
        this._name = name;
        this._table = table;
        this._tableIndex = tableIndex;
        this._columnIndex = columnIndex;
        this._column = table.getColumns()[this._columnIndex];
        this._type = type;
    }

    @Override
    public Class<?> getType() {
        return this._type;
    }

    @Override
    public Column.ColumnType getTypeCode() {
        return this.getColumn().getTypeCode();
    }

    @Override
    public int getSQLType() {
        return this.getColumn().getSQLType();
    }

    @Override
    public String getName() {
        return this._name;
    }

    public Column getColumn() {
        return this._column;
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public boolean isNullable() {
        return !this._column.isNotNull();
    }

    @Override
    public final boolean isNull(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isNull(this._column);
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getString(this._column);
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getInteger(this._column);
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getLong(this._column);
    }

    @Override
    public final double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getDouble(this._column);
    }

    @Override
    public int evalToBuffer(QueryContext context, byte[] buffer, int offset) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getBuffer(this._column, buffer, offset);
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        row.evalToResult(this._column, result);
    }

    @Override
    public boolean evalEqual(QueryContext context, byte[] matchBuffer) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isEqual(this._column, matchBuffer);
    }

    @Override
    public boolean evalEqual(QueryContext context, String string) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.isEqual(this._column, string);
    }

    public boolean equals(Object o) {
        if (o == null || !ColumnExpr.class.equals(o.getClass())) {
            return false;
        }
        ColumnExpr expr = (ColumnExpr)o;
        return this._tableIndex == expr._tableIndex && this._column == expr._column;
    }

    public String toString() {
        return "ColumnExpr[" + this._tableIndex + "," + this._columnIndex + "]";
    }
}

