/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.AutoIncrementExpr;
import com.caucho.db.sql.DefaultExpr;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.IdentityExpr;
import com.caucho.db.sql.NullExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;

class InsertQuery
extends Query {
    private Table _table;
    private ArrayList<Column> _columns;
    private ArrayList<Expr> _values;

    InsertQuery(Database db, String sql, Table table, ArrayList<Column> columns) throws SQLException {
        super(db, sql, null);
        this._table = table;
        this._columns = columns;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public void setValues(ArrayList<Expr> values) {
        this._values = values;
    }

    void init() throws SQLException {
        Column[] tableColumns = this._table.getColumns();
        for (int i = 0; i < tableColumns.length; ++i) {
            int j;
            Column column = tableColumns[i];
            Expr defaultExpr = column.getDefault();
            if (column.getTypeCode() == Column.ColumnType.IDENTITY) {
                defaultExpr = new IdentityExpr(column.getTable(), column);
            } else if (column.getAutoIncrement() > 0) {
                defaultExpr = new AutoIncrementExpr(column.getTable());
            }
            if (defaultExpr == null) continue;
            for (j = 0; j < this._columns.size() && this._columns.get(j) != column; ++j) {
            }
            if (j == this._columns.size()) {
                this._columns.add(column);
                this._values.add(new NullExpr());
            }
            this._values.set(j, new DefaultExpr(this._values.get(j), defaultExpr));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(QueryContext queryContext, DbTransaction xa) throws SQLException {
        TableIterator[] rows = new TableIterator[1];
        try {
            Table table = this._table;
            synchronized (table) {
                try {
                    rows[0] = this._table.createTableIterator();
                    queryContext.init(xa, rows, this.isReadOnly());
                    this._table.insert(queryContext, xa, this._columns, this._values);
                    queryContext.setRowUpdateCount(1);
                    xa.writeData();
                }
                catch (IOException e) {
                    throw new SQLExceptionWrapper(e);
                }
                finally {
                    queryContext.close();
                }
            }
        }
        finally {
            this._table.wakeWriter();
        }
    }

    public String toString() {
        return "InsertQuery[]";
    }
}

