/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.Column;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import java.sql.SQLException;
import java.util.ArrayList;

class OidExpr
extends Expr {
    private Table _table;
    private int _tableIndex;
    private FromItem _fromItem;

    OidExpr(FromItem fromItem, Table table, int tableIndex) {
        this._fromItem = fromItem;
        this._table = table;
        this._tableIndex = tableIndex;
    }

    FromItem getFromItem() {
        return this._fromItem;
    }

    @Override
    public Class<?> getType() {
        return Long.TYPE;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public int getSQLType() {
        return Column.ColumnType.IDENTITY.getSQLType();
    }

    @Override
    public String getName() {
        return "resin_oid";
    }

    @Override
    public Table getTable() {
        return this._table;
    }

    @Override
    public long indexSubCost(ArrayList<FromItem> costItems) {
        if (!costItems.contains(this._fromItem)) {
            return 100000000L;
        }
        return 9223372036854774L;
    }

    @Override
    public long subCost(ArrayList<FromItem> costItems) {
        if (costItems.contains(this._fromItem)) {
            return 0L;
        }
        return 9223372036854775L;
    }

    @Override
    public Expr bind(Query query) {
        FromItem[] fromItems = query.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (fromItems[i] != this._fromItem) continue;
            this._tableIndex = i;
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isNull(QueryContext context) throws SQLException {
        return false;
    }

    @Override
    public String evalString(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return String.valueOf(row.getRowAddress());
    }

    public int evalInt(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return (int)row.getRowAddress();
    }

    @Override
    public long evalLong(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    @Override
    public double evalDouble(QueryContext context) throws SQLException {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        return row.getRowAddress();
    }

    @Override
    public void evalToResult(QueryContext context, SelectResult result) {
        TableIterator[] rows = context.getTableIterators();
        TableIterator row = rows[this._tableIndex];
        result.writeLong(row.getRowAddress());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._fromItem + "," + this._tableIndex + "]";
    }
}

