/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.sql.Expr;
import com.caucho.db.sql.OidExpr;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.RowIterateExpr;
import com.caucho.db.table.TableIterator;
import java.io.IOException;
import java.sql.SQLException;

class OidIndexExpr
extends RowIterateExpr {
    private OidExpr _columnExpr;
    private Expr _expr;

    OidIndexExpr(OidExpr index, Expr expr) {
        this._expr = expr;
        this._columnExpr = index;
        if (expr == null || index == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Expr bind(Query query) throws SQLException {
        this._expr = this._expr.bind(query);
        return this;
    }

    @Override
    boolean allowChildRowShift(QueryContext context, TableIterator rowIter) {
        return false;
    }

    @Override
    boolean init(QueryContext context, TableIterator rowIter) throws SQLException, IOException {
        rowIter.init(context);
        return true;
    }

    @Override
    boolean initRow(QueryContext context, TableIterator tableIter) throws SQLException, IOException {
        long rowAddr = this.evalIndex(context);
        if (rowAddr == 0L) {
            return false;
        }
        if (!tableIter.isValidRow(rowAddr)) {
            return false;
        }
        tableIter.setRow(rowAddr);
        return true;
    }

    @Override
    boolean nextRow(QueryContext context, TableIterator table) {
        return false;
    }

    long evalIndex(QueryContext context) throws SQLException {
        long value = this._expr.evalLong(context);
        if (value <= 0L) {
            return 0L;
        }
        return value;
    }

    @Override
    boolean nextBlock(QueryContext context, TableIterator rowIter) throws IOException, SQLException {
        context.unlock();
        return false;
    }

    public String toString() {
        return "(" + this._columnExpr + " = " + this._expr + ")";
    }
}

