/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache;

import com.caucho.cache.Cache;
import com.caucho.cache.CacheException;
import com.caucho.cache.CacheLoader;
import com.caucho.cache.CacheMXBean;
import com.caucho.cache.CacheStatistics;
import com.caucho.cache.CacheWriter;
import com.caucho.cache.Configuration;
import com.caucho.cache.Status;
import com.caucho.cache.event.CacheEntryEventFilter;
import com.caucho.cache.event.CacheEntryListener;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.db.block.BlockManager;
import com.caucho.distcache.ByteStreamCache;
import com.caucho.distcache.CacheSerializer;
import com.caucho.distcache.ExtCacheEntry;
import com.caucho.distcache.ObjectCache;
import com.caucho.distcache.ResinCacheBuilder;
import com.caucho.distcache.jcache.CacheManagerFacade;
import com.caucho.loader.Environment;
import com.caucho.server.distcache.CacheBacking;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheEngine;
import com.caucho.server.distcache.CacheImpl;
import com.caucho.server.distcache.CacheManagerImpl;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DistCacheSystem;
import com.caucho.server.distcache.MnodeStore;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.util.HashKey;
import com.caucho.util.L10N;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.WriteStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;

public class AbstractCache
implements ObjectCache,
ByteStreamCache,
ResinCacheBuilder,
Closeable {
    private static final L10N L = new L10N(AbstractCache.class);
    private String _name;
    private String _managerName;
    private CacheManagerFacade _cacheManager;
    private String _guid;
    private CacheConfig _config = new CacheConfig();
    private boolean _isClosed;
    private CacheImpl _delegate;
    private long _memorySizeMin;

    public AbstractCache() {
        DistCacheSystem cacheService = DistCacheSystem.getCurrent();
        if (cacheService == null) {
            throw new ConfigException(L.l("'{0}' cannot be initialized because it is not in a Resin environment", (Object)this.getClass().getSimpleName()));
        }
        this._config.setEngine(cacheService.getDistCacheManager().getCacheEngine());
    }

    public String getName() {
        return this._name;
    }

    @Configurable
    public void setName(String name) {
        this._name = name;
    }

    @Configurable
    public void setManagerName(String managerName) {
        this._managerName = managerName;
    }

    public CacheManagerFacade getCacheManager() {
        return this._cacheManager;
    }

    public void setCacheManager(CacheManagerFacade cacheManager) {
        this._cacheManager = cacheManager;
    }

    @Configurable
    public void setCacheLoader(CacheLoader loader) {
        this._config.setCacheLoader(loader);
    }

    @Configurable
    public void setReadThrough(boolean isReadThrough) {
        this._config.setReadThrough(isReadThrough);
    }

    @Configurable
    public void setReadThroughExpireTimeout(Period timeout) {
        this._config.setReadThroughExpireTimeout(timeout.getPeriod());
    }

    public void setReadThroughExpireTimeoutMillis(long timeout) {
        this._config.setReadThroughExpireTimeout(timeout);
    }

    @Configurable
    public void setCacheWriter(CacheWriter writer) {
        this._config.setCacheWriter(writer);
    }

    @Configurable
    public void setWriteThrough(boolean isWriteThrough) {
        this._config.setWriteThrough(isWriteThrough);
    }

    @Configurable
    public void setCacheReaderWriter(CacheLoader loader) {
        if (!(loader instanceof CacheWriter)) {
            throw new ConfigException(L.l("cache-reader-writer '{0}' must implements both CacheLoader and CacheWriter.", (Object)loader));
        }
        this._config.setCacheLoader(loader);
        this._config.setReadThrough(true);
        this._config.setCacheWriter((CacheWriter)loader);
        this._config.setWriteThrough(true);
    }

    @Configurable
    public void setSerializer(CacheSerializer serializer) {
        this._config.setValueSerializer(serializer);
    }

    public void setEngine(CacheEngine engine) {
        this._config.setEngine(engine);
    }

    @Configurable
    public void setAccessedExpireTimeout(Period period) {
        this.setAccessedExpireTimeoutMillis(period.getPeriod());
    }

    @Configurable
    public void setIdleTimeout(Period period) {
        this.setAccessedExpireTimeout(period);
    }

    public long getAccessedExpireTimeout() {
        return this._config.getAccessedExpireTimeout();
    }

    @Configurable
    public void setAccessedExpireTimeoutMillis(long timeout) {
        this._config.setAccessedExpireTimeout(timeout);
    }

    public long getAccessedExpireTimeoutWindow() {
        return this._config.getAccessedExpireTimeoutWindow();
    }

    public void setAccessedExpireTimeoutWindow(Period period) {
        this._config.setAccessedExpireTimeoutWindow(period.getPeriod());
    }

    public long getModifiedExpireTimeout() {
        return this._config.getModifiedExpireTimeout();
    }

    @Configurable
    public void setModifiedExpireTimeout(Period expireTimeout) {
        this.setModifiedExpireTimeoutMillis(expireTimeout.getPeriod());
    }

    @Configurable
    public void setExpireTimeout(Period expireTimeout) {
        this.setModifiedExpireTimeout(expireTimeout);
    }

    @Configurable
    public void setModifiedExpireTimeoutMillis(long expireTimeout) {
        this._config.setModifiedExpireTimeout(expireTimeout);
    }

    public long getLeaseExpireTimeout() {
        return this._config.getLeaseExpireTimeout();
    }

    @Configurable
    public void setLeaseExpireTimeout(Period period) {
        this.setLeaseExpireTimeoutMillis(period.getPeriod());
    }

    @Configurable
    public void setLeaseTimeout(Period period) {
        this.setLeaseExpireTimeout(period);
    }

    @Configurable
    public void setLeaseExpireTimeoutMillis(long timeout) {
        this._config.setLeaseExpireTimeout(timeout);
    }

    public long getLocalExpireTimeout() {
        return this._config.getLocalExpireTimeout();
    }

    @Configurable
    public void setLocalExpireTimeout(Period period) {
        this.setLocalExpireTimeoutMillis(period.getPeriod());
    }

    @Configurable
    public void setLocalReadTimeout(Period period) {
        this.setLocalExpireTimeout(period);
    }

    @Configurable
    public void setLocalExpireTimeoutMillis(long period) {
        this._config.setLocalExpireTimeout(period);
    }

    public void setScopeMode(ResinCacheBuilder.Scope scope) {
        this._config.setScopeMode(scope);
    }

    public boolean isBackup() {
        return this._config.isBackup();
    }

    public boolean isTriplicate() {
        return this._config.isTriplicate();
    }

    public void setBacking(CacheBacking<?, ?> backing) {
        this._config.setCacheLoader(backing);
        this._config.setReadThrough(true);
        this._config.setCacheWriter(backing);
        this._config.setWriteThrough(true);
    }

    public void setPersistenceMode(ResinCacheBuilder.Persistence persistence) {
    }

    @Configurable
    public void setMemorySizeMin(Bytes size) {
        this._memorySizeMin = size.getBytes();
    }

    public Object peek(Object key) {
        return this._delegate.peek(key);
    }

    public HashKey getKeyHash(Object key) {
        return this._delegate.getKeyHash(key);
    }

    public Object get(Object key) {
        return this._delegate.get(key);
    }

    @Override
    public boolean get(Object key, OutputStream os) throws IOException {
        return this._delegate.get(key, os);
    }

    public ExtCacheEntry getExtCacheEntry(Object key) {
        return this._delegate.getExtCacheEntry(key);
    }

    public ExtCacheEntry getExtCacheEntry(HashKey key) {
        return this._delegate.getExtCacheEntry(key);
    }

    public ExtCacheEntry peekExtCacheEntry(Object key) {
        return this._delegate.peekExtCacheEntry(key);
    }

    public ExtCacheEntry getStatCacheEntry(Object key) {
        return this._delegate.getStatCacheEntry(key);
    }

    public Cache.Entry getCacheEntry(Object key) {
        return this._delegate.getExtCacheEntry(key);
    }

    public ExtCacheEntry getLiveCacheEntry(Object key) {
        return this._delegate.getLiveCacheEntry(key);
    }

    public void put(Object key, Object value) {
        this._delegate.put(key, value);
    }

    public boolean putIfAbsent(Object key, Object value) throws CacheException {
        return this._delegate.putIfAbsent(key, value);
    }

    public boolean replace(Object key, Object oldValue, Object value) throws CacheException {
        return this._delegate.replace(key, oldValue, value);
    }

    public boolean replace(Object key, Object value) throws CacheException {
        return this._delegate.replace(key, value);
    }

    public Object getAndReplace(Object key, Object value) throws CacheException {
        return this._delegate.getAndReplace(key, value);
    }

    @Override
    public boolean remove(Object key) {
        return this._delegate.remove(key);
    }

    public boolean remove(Object key, Object oldValue) {
        return this._delegate.remove(key, oldValue);
    }

    public Object getAndRemove(Object key) throws CacheException {
        return this._delegate.getAndRemove(key);
    }

    @Override
    public boolean compareAndRemove(Object key, long version) {
        return this._delegate.compareAndRemove(key, version);
    }

    public Future load(Object key) throws CacheException {
        return this._delegate.load(key);
    }

    public Future loadAll(Set keys) throws CacheException {
        return this._delegate.loadAll(keys);
    }

    public void removeAll() throws CacheException {
        this._delegate.removeAll();
    }

    public Iterator iterator() {
        return this._delegate.iterator();
    }

    public Status getStatus() {
        return this._delegate.getStatus();
    }

    public void start() throws CacheException {
    }

    public void stop() throws CacheException {
    }

    public Object unwrap(Class cl) {
        return this._delegate.unwrap(cl);
    }

    public ExtCacheEntry put(Object key, InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout, int userFlags) throws IOException {
        return this._delegate.put(key, is, accessedExpireTimeout, modifiedExpireTimeout, userFlags);
    }

    public ExtCacheEntry put(Object key, InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout) throws IOException {
        return this._delegate.put(key, is, accessedExpireTimeout, modifiedExpireTimeout);
    }

    public ExtCacheEntry put(Object key, InputStream is, long accessedExpireTimeout, long modifiedExpireTimeout, long lastAccessTime, long lastModifiedTime) throws IOException {
        return this._delegate.put(key, is, accessedExpireTimeout, modifiedExpireTimeout, lastAccessTime, lastModifiedTime);
    }

    @Override
    public boolean putIfNew(Object key, MnodeUpdate update, InputStream is) throws IOException {
        return this._delegate.putIfNew(key, update, is);
    }

    public Object getAndPut(Object key, Object value) {
        return this._delegate.getAndPut(key, value);
    }

    public boolean compareVersionAndPut(Object key, long version, Object value) {
        return this._delegate.compareVersionAndPut(key, version, value);
    }

    public Map getAll(Collection keys) {
        HashMap result = new HashMap();
        for (Object key : keys) {
            Object value = this.get(key);
            if (value == null) continue;
            result.put(key, value);
        }
        return result;
    }

    public boolean unregisterCacheEntryListener(CacheEntryListener listener) {
        return this._delegate.unregisterCacheEntryListener(listener);
    }

    public CacheStatistics getStatistics() {
        return this._delegate.getStatistics();
    }

    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Set entries = map.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsKey(Object key) {
        return this._delegate.containsKey(key);
    }

    public HashKey getCacheKey() {
        return this._config.getCacheKey();
    }

    protected Object cacheLoader(Object key) {
        Object value = this.get(key);
        if (value != null) {
            return value;
        }
        CacheLoader loader = this._config.getCacheLoader();
        Object arg = null;
        Object object = value = loader != null ? loader.load(key) : null;
        if (value != null) {
            this.put(key, value);
        }
        this.notifyLoad(key);
        return value;
    }

    protected void notifyLoad(Object key) {
    }

    protected void notifyEvict(Object key) {
    }

    protected void notifyClear(Object key) {
    }

    protected void notifyPut(Object key) {
    }

    protected void notifyRemove(Object key) {
    }

    @Override
    public boolean isClosed() {
        return this._isClosed;
    }

    @Override
    public void close() {
    }

    private void initName(String name) throws ConfigException {
        if (this._name == null || this._name.length() == 0) {
            throw new ConfigException(L.l("Each Cache must have a name."));
        }
        String contextId = Environment.getEnvironmentName();
        if (this._cacheManager != null) {
            contextId = this._cacheManager.getGuid();
        }
        if (this._guid == null) {
            this._guid = contextId + ":" + this._name;
        }
        this._config.setGuid(this._guid);
    }

    public boolean loadData(long valueIndex, long valueDataTime, WriteStream os) throws IOException {
        return this._delegate.loadData(valueIndex, valueDataTime, os);
    }

    public DataStore.DataItem saveData(StreamSource source, int length) throws IOException {
        return this._delegate.saveData(source, length);
    }

    public boolean isDataAvailable(long valueDataId, long valueDataTime) {
        return this._delegate.isDataAvailable(valueDataId, valueDataTime);
    }

    public byte[] getKeyHash(String name) {
        return this._delegate.getKeyHash(name);
    }

    public long getValueHash(Object value) {
        return this._delegate.getValueHash(value);
    }

    public MnodeStore getMnodeStore() {
        return this._delegate.getMnodeStore();
    }

    public DataStore getDataStore() {
        return this._delegate.getDataStore();
    }

    public CacheImpl createIfAbsent() {
        this.init();
        return this._delegate;
    }

    @PostConstruct
    public void init() {
        if (this._delegate != null) {
            return;
        }
        this._config.init();
        this.initName(this._name);
        DistCacheSystem cacheService = DistCacheSystem.getCurrent();
        if (cacheService == null) {
            throw new ConfigException(L.l("'{0}' cannot be initialized because it is not in a Resin environment", (Object)this.getClass().getSimpleName()));
        }
        String managerName = this._managerName;
        if (managerName == null && this._cacheManager != null) {
            managerName = this._cacheManager.getName();
        }
        CacheManagerImpl manager = managerName != null ? cacheService.getCacheManager(managerName) : cacheService.getCacheManager();
        if (this._config.getEngine() == null) {
            this._config.setEngine(cacheService.getDistCacheManager().getCacheEngine());
        }
        if (this._memorySizeMin > 0L) {
            BlockManager.create().ensureMemoryCapacity(this._memorySizeMin);
        }
        this._delegate = manager.createIfAbsent(this._name, this._config);
    }

    public Configuration getConfiguration() {
        return this._delegate.getConfiguration();
    }

    public CacheConfig getConfig() {
        return this._config;
    }

    public Map getAll(Set keys) {
        return this._delegate.getAll(keys);
    }

    public Object invokeEntryProcessor(Object key, Cache.EntryProcessor entryProcessor) {
        return this._delegate.invokeEntryProcessor(key, entryProcessor);
    }

    public void removeAll(Set keys) {
        this._delegate.removeAll(keys);
    }

    public CacheMXBean getMBean() {
        return this._delegate.getMBean();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._guid + "]";
    }

    public boolean registerCacheEntryListener(CacheEntryListener listener, boolean requireOldValue, CacheEntryEventFilter filter, boolean synchronous) {
        return false;
    }
}

