/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache.jcache;

import com.caucho.cache.Cache;
import com.caucho.cache.CacheBuilder;
import com.caucho.cache.CacheLoader;
import com.caucho.cache.CacheWriter;
import com.caucho.cache.Configuration;
import com.caucho.cache.event.CacheEntryListener;
import com.caucho.cache.transaction.IsolationLevel;
import com.caucho.cache.transaction.Mode;
import com.caucho.distcache.ClusterCache;
import com.caucho.distcache.jcache.CacheManagerFacade;

public class CacheBuilderImpl<K, V>
implements CacheBuilder<K, V> {
    private String _name;
    private String _guid;
    private CacheManagerFacade _manager;
    private ClusterCache _cache;

    CacheBuilderImpl(String name, CacheManagerFacade manager) {
        this._name = name;
        this._manager = manager;
        this._guid = this._manager.getGuid() + ":" + name;
        this._cache = new ClusterCache();
        this._cache.setName(name);
        this._cache.setCacheManager(manager);
    }

    public Cache<K, V> build() {
        this._cache.init();
        this._manager.addCache(this._name, this._cache);
        return this._manager.getCache(this._name);
    }

    public CacheBuilder<K, V> registerCacheEntryListener(CacheEntryListener<K, V> listener) {
        return this;
    }

    public CacheBuilder<K, V> setCacheLoader(CacheLoader<K, ? extends V> cacheLoader) {
        this._cache.getConfig().setCacheLoader(cacheLoader);
        return this;
    }

    public CacheBuilder<K, V> setReadThrough(boolean readThrough) {
        this._cache.getConfig().setReadThrough(readThrough);
        return this;
    }

    public CacheBuilder<K, V> setCacheWriter(CacheWriter<? super K, ? super V> cacheWriter) {
        this._cache.getConfig().setCacheWriter(cacheWriter);
        return this;
    }

    public CacheBuilder<K, V> setWriteThrough(boolean isWriteThrough) {
        this._cache.getConfig().setWriteThrough(isWriteThrough);
        return this;
    }

    public CacheBuilder<K, V> setExpiry(Configuration.ExpiryType type, Configuration.Duration timeToLive) {
        this._cache.getConfig().setExpiry(type, timeToLive);
        return this;
    }

    public CacheBuilder<K, V> setStatisticsEnabled(boolean isEnable) {
        this._cache.getConfig().setStatisticsEnabled(isEnable);
        return this;
    }

    public CacheBuilder<K, V> setStoreByValue(boolean storeByValue) {
        this._cache.getConfig().setStoreByValue(storeByValue);
        return this;
    }

    public CacheBuilder<K, V> setTransactionEnabled(IsolationLevel isolationLevel, Mode mode) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._guid + "]";
    }
}

