/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.distcache.jcache;

import com.caucho.cache.CacheManager;
import com.caucho.cache.CacheManagerFactory;
import com.caucho.cache.CachingShutdownException;
import com.caucho.config.ConfigException;
import com.caucho.distcache.jcache.CacheManagerFacade;
import com.caucho.server.distcache.CacheManagerImpl;
import com.caucho.server.distcache.DistCacheSystem;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;

public class CacheManagerFactoryImpl
implements CacheManagerFactory {
    private static final L10N L = new L10N(CacheManagerFactoryImpl.class);
    private HashMap<String, CacheManagerFacade> _cacheManagerMap = new HashMap();

    public CacheManager getCacheManager(String name) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return this.getCacheManager(loader, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(ClassLoader classLoader, String name) {
        HashMap<String, CacheManagerFacade> hashMap = this._cacheManagerMap;
        synchronized (hashMap) {
            CacheManagerFacade cm = this._cacheManagerMap.get(name);
            if (cm == null) {
                DistCacheSystem cacheService = DistCacheSystem.getCurrent();
                if (cacheService == null) {
                    throw new ConfigException(L.l("'{0}' cannot be initialized because it is not in a Resin environment", (Object)this.getClass().getSimpleName()));
                }
                CacheManagerImpl manager = name != null ? cacheService.getCacheManager(name) : cacheService.getCacheManager();
                cm = new CacheManagerFacade(name, classLoader, manager);
                this._cacheManagerMap.put(name, cm);
            }
            return cm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CachingShutdownException {
        ArrayList<CacheManagerFacade> managerList = new ArrayList<CacheManagerFacade>();
        HashMap<String, CacheManagerFacade> hashMap = this._cacheManagerMap;
        synchronized (hashMap) {
            managerList.addAll(this._cacheManagerMap.values());
            this._cacheManagerMap.clear();
        }
        for (CacheManagerFacade manager : managerList) {
            manager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) throws CachingShutdownException {
        ArrayList<CacheManagerFacade> managerList = new ArrayList<CacheManagerFacade>();
        HashMap<String, CacheManagerFacade> hashMap = this._cacheManagerMap;
        synchronized (hashMap) {
            managerList.addAll(this._cacheManagerMap.values());
            this._cacheManagerMap.clear();
        }
        for (CacheManagerFacade manager : managerList) {
            manager.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader, String name) throws CachingShutdownException {
        CacheManagerFacade cm;
        HashMap<String, CacheManagerFacade> hashMap = this._cacheManagerMap;
        synchronized (hashMap) {
            cm = this._cacheManagerMap.remove(name);
        }
        if (cm != null) {
            cm.close();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

