/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.cfg.AbstractBeanConfig;
import com.caucho.config.inject.InjectManager;
import com.caucho.ejb.cfg.EjbConfigManager;
import com.caucho.ejb.cfg.EjbMessageBean;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.resource.spi.ActivationSpec;

public class MessageBeanConfig
extends AbstractBeanConfig {
    private static final L10N L = new L10N(MessageBeanConfig.class);
    private ActivationSpec _activationSpec;
    private Class<?> _destinationType;
    private String _destinationName;
    private Object _destination;
    private int _messageConsumerMax;

    public void setActivationSpec(ActivationSpec spec) {
        this._activationSpec = spec;
    }

    public void add(ActivationSpec spec) {
        this._activationSpec = spec;
    }

    public void setDestinationType(Class<?> type) {
        this._destinationType = type;
    }

    public void setDestinationName(String name) {
        this._destinationName = name;
    }

    public void setDestination(Object destination) {
        this._destination = destination;
        if (destination == null) {
            throw new ConfigException(L.l("'destination' attribute may not be null"));
        }
    }

    public void setMessageConsumerMax(int messageConsumerMax) {
        this._messageConsumerMax = messageConsumerMax;
    }

    @Override
    public void initImpl() {
        if (this.getInstanceClass() == null) {
            throw new ConfigException(L.l("ejb-message-bean requires a 'class' attribute"));
        }
        EjbManager ejbContainer = EjbManager.create();
        EjbConfigManager configManager = ejbContainer.getConfigManager();
        EjbMessageBean bean = new EjbMessageBean(configManager, "config");
        bean.setConfigLocation(this.getFilename(), this.getLine());
        bean.setEJBClass(this.getInstanceClass());
        String name = this.getName();
        if (name == null) {
            name = this.getJndiName();
        }
        if (name == null) {
            name = this.getInstanceClass().getSimpleName();
        }
        bean.setEJBName(name);
        if (this.getInit() != null) {
            bean.setInit(this.getInit());
        }
        String loc = this.getInstanceClass().getName() + ": ";
        InjectManager webBeans = InjectManager.create();
        bean.setMessageConsumerMax(this._messageConsumerMax);
        if (this._destination != null) {
            bean.setDestinationValue((Destination)this._destination);
        } else if (this._activationSpec != null) {
            bean.setActivationSpec(this._activationSpec);
        } else {
            CreationalContext env;
            Class<Object> destinationType = this._destinationType;
            if (this._destinationType == null) {
                destinationType = Destination.class;
            }
            Set<Object> beanSet = this._destinationName != null ? webBeans.getBeans(this._destinationName) : webBeans.getBeans(destinationType, new Annotation[0]);
            Object destComp = null;
            if (beanSet.size() > 0) {
                Bean destBean = webBeans.resolve(beanSet);
                env = webBeans.createCreationalContext(destBean);
                destComp = webBeans.getReference(destBean, destBean.getBeanClass(), env);
            }
            if (destComp == null) {
                throw new ConfigException(L.l("{0}: '{1}' is an unknown destination type '{2}'", (Object)loc, (Object)this._destinationName, (Object)this._destinationType.getName()));
            }
            bean.setDestinationValue((Destination)destComp);
            beanSet = webBeans.getBeans((Type)((Object)ConnectionFactory.class), new Annotation[0]);
            Bean factoryBean = webBeans.resolve(beanSet);
            env = webBeans.createCreationalContext(factoryBean);
            Object comp = webBeans.getReference(factoryBean);
            if (comp == null) {
                throw new ConfigException(L.l("ejb-message-bean requires a configured JMS ConnectionFactory"));
            }
            bean.setConnectionFactoryValue((ConnectionFactory)comp);
        }
        bean.init();
        configManager.setBeanConfig(name, bean);
    }
}

