/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.MethodHeadFactory;
import com.caucho.ejb.gen.StatefulAspectBeanFactory;
import com.caucho.ejb.gen.StatefulMethodHeadGenerator;
import com.caucho.inject.Module;
import javax.ejb.AccessTimeout;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class StatefulMethodHeadFactory<X>
extends MethodHeadFactory<X> {
    private AccessTimeout _classAccessTimeout;

    public StatefulMethodHeadFactory(StatefulAspectBeanFactory<X> beanFactory, AspectFactory<X> next) {
        super(beanFactory, next);
        AnnotatedType beanType = beanFactory.getBeanType();
        this._classAccessTimeout = (AccessTimeout)beanType.getAnnotation(AccessTimeout.class);
    }

    @Override
    public AspectGenerator<X> create(AnnotatedMethod<? super X> method, boolean isEnhanced) {
        AnnotatedType declaringType = method.getDeclaringType();
        AccessTimeout accessTimeout = (AccessTimeout)method.getAnnotation(AccessTimeout.class);
        if (accessTimeout == null) {
            accessTimeout = (AccessTimeout)declaringType.getAnnotation(AccessTimeout.class);
        }
        AspectGenerator<? super X> next = super.create(method, true);
        if (accessTimeout != null) {
            return new StatefulMethodHeadGenerator<X>(this, method, next, accessTimeout.value(), accessTimeout.unit());
        }
        return new StatefulMethodHeadGenerator<X>(this, method, next);
    }
}

