/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.LifecycleInterceptor;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InterceptorRuntimeBean;
import com.caucho.ejb.gen.SessionGenerator;
import com.caucho.ejb.gen.StatelessAspectBeanFactory;
import com.caucho.ejb.gen.StatelessLifecycleAspectBeanFactory;
import com.caucho.ejb.gen.StatelessScheduledAspectBeanFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Stateless;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Interceptor;

@Module
public class StatelessGenerator<X>
extends SessionGenerator<X> {
    private static final L10N L = new L10N(StatelessGenerator.class);
    private String _timeoutMethod;
    private LifecycleInterceptor _postConstructInterceptor;
    private LifecycleInterceptor _preDestroyInterceptor;
    private final AspectBeanFactory<X> _aspectBeanFactory;
    private final StatelessScheduledAspectBeanFactory<X> _scheduledBeanFactory;
    private final AspectBeanFactory<X> _lifecycleAspectFactory;

    public StatelessGenerator(String ejbName, AnnotatedType<X> beanType, ArrayList<AnnotatedType<? super X>> localApi, AnnotatedType<X> localBean, ArrayList<AnnotatedType<? super X>> remoteApi) {
        super(ejbName, beanType, localApi, localBean, remoteApi, Stateless.class.getSimpleName());
        InjectManager manager = InjectManager.create();
        this._aspectBeanFactory = new StatelessAspectBeanFactory(manager, this.getBeanType());
        this._scheduledBeanFactory = new StatelessScheduledAspectBeanFactory(manager, this.getBeanType());
        this._lifecycleAspectFactory = new StatelessLifecycleAspectBeanFactory<X>(this._aspectBeanFactory, manager, this.getBeanType());
    }

    @Override
    protected AspectBeanFactory<X> getAspectBeanFactory() {
        return this._aspectBeanFactory;
    }

    @Override
    protected AspectBeanFactory<X> getScheduledAspectBeanFactory() {
        return this._scheduledBeanFactory;
    }

    @Override
    protected AspectBeanFactory<X> getLifecycleAspectFactory() {
        return this._lifecycleAspectFactory;
    }

    @Override
    public boolean isStateless() {
        return true;
    }

    @Override
    protected boolean isTimerSupported() {
        return true;
    }

    @Override
    protected AnnotatedType<? super X> introspectLocalDefault() {
        return this.getBeanType();
    }

    public String getContextClassName() {
        return this.getClassName();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public String getViewClassName() {
        return "StatelessLocal";
    }

    @Override
    public String getBeanClassName() {
        return this.getBeanType().getJavaClass().getName();
    }

    @Override
    protected String getLifecycleInstance() {
        return "_statelessPool.getLifecycleInstance()";
    }

    @Override
    public void introspect() {
        super.introspect();
        this.introspectLifecycle(this.getBeanType().getJavaClass());
        this._postConstructInterceptor = new LifecycleInterceptor(PostConstruct.class);
        this._postConstructInterceptor.introspect(this.getBeanType());
        this._preDestroyInterceptor = new LifecycleInterceptor(PreDestroy.class);
        this._preDestroyInterceptor.introspect(this.getBeanType());
        this.introspectTimer(this.getBeanType());
    }

    public void introspectLifecycle(Class<?> cl) {
        if (cl == null || cl.equals(Object.class)) {
            return;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
        }
        this.introspectLifecycle(cl.getSuperclass());
    }

    public void introspectTimer(AnnotatedType<X> apiClass) {
        Class cl = apiClass.getJavaClass();
        if (cl == null || cl.equals(Object.class)) {
            return;
        }
        if (TimedObject.class.isAssignableFrom(cl)) {
            this._timeoutMethod = "ejbTimeout";
            return;
        }
        for (AnnotatedMethod apiMethod : apiClass.getMethods()) {
            Method method = apiMethod.getJavaMember();
            if (!method.isAnnotationPresent(Timeout.class)) continue;
            if (!(method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && Timer.class.equals(method.getParameterTypes()[0]))) {
                throw new ConfigException(L.l("{0}: timeout method '{1}' does not have a (Timer) parameter", (Object)cl.getName(), (Object)method.getName()));
            }
            this._timeoutMethod = method.getName();
            this.addBusinessMethod(apiMethod);
        }
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        this.generateTopComment(out);
        out.println();
        out.println("package " + this.getPackageName() + ";");
        out.println();
        out.println("import com.caucho.config.*;");
        out.println("import com.caucho.ejb.session.*;");
        out.println();
        out.println("import javax.ejb.*;");
        out.println("import javax.transaction.*;");
        this.generateHeader(out);
        out.println("{");
        out.pushDepth();
        this.generateBody(out);
        this.generateDependency(out);
        out.popDepth();
        out.println("}");
    }

    public void generateHeader(JavaWriter out) throws IOException {
        out.println();
        out.println("public class " + this.getClassName() + "<T>");
        if (this.hasNoInterfaceView()) {
            out.println("  extends " + this.getBeanType().getJavaClass().getName());
        }
        out.print("  implements SessionProxyFactory<T>");
        out.print(", StatelessProxyFactory");
        for (AnnotatedType api : this.getLocalApi()) {
            out.print(", ");
            out.printType(api.getBaseType());
        }
        for (AnnotatedType apiType : this.getRemoteApi()) {
            out.print(", ");
            out.printType(apiType.getBaseType());
        }
        out.println();
    }

    private void generateBody(JavaWriter out) throws IOException {
        this.generateClassStaticFields(out);
        out.println("private static final boolean __caucho_isFiner = __caucho_log.isLoggable(java.util.logging.Level.FINER);");
        out.println();
        out.println("private final StatelessManager _manager;");
        out.println();
        out.println("private final StatelessPool<" + this.getBeanClassName() + ",T> _statelessPool;");
        this.generateConstructor(out);
        this.generateProxyPool(out);
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.generateBusinessMethods(out, map);
        this.generatePostConstruct(out, map);
        out.println();
        out.println("public void destroy()");
        out.println("{");
        out.pushDepth();
        this.generateDestroyViews(out);
        out.popDepth();
        out.println("}");
    }

    private void generateConstructor(JavaWriter out) throws IOException {
        out.println();
        out.print("private static final ");
        out.print("java.util.ArrayList<");
        out.printClass(Interceptor.class);
        out.println("<?>> __caucho_interceptor_beans");
        out.print("  = new java.util.ArrayList<");
        out.printClass(Interceptor.class);
        out.println("<?>>();");
        out.println();
        out.print("private static final ");
        out.print("java.util.ArrayList<");
        out.printClass(InterceptorRuntimeBean.class);
        out.println("<?>> __caucho_interceptor_static_beans");
        out.print("  = new java.util.ArrayList<");
        out.printClass(InterceptorRuntimeBean.class);
        out.println("<?>>();");
        out.println();
        out.println("public " + this.getClassName() + "(StatelessManager manager, StatelessContext context)");
        out.println("{");
        out.pushDepth();
        out.println("_manager = manager;");
        out.println("_statelessPool = manager.createStatelessPool(this, context, __caucho_interceptor_beans);");
        this.generateProxyConstructor(out);
        out.popDepth();
        out.println("}");
        out.println();
        out.println("@Override");
        out.println("public T __caucho_createProxy(com.caucho.config.inject.CreationalContextImpl<T> env)");
        out.println("{");
        out.println("  return (T) this;");
        out.println("}");
    }

    public void generateProxy(JavaWriter out) throws IOException {
        out.println();
        out.println("{");
        out.pushDepth();
        out.println();
        out.println(this.getClassName() + "()");
        out.println("{");
        out.pushDepth();
        out.println("_context = context;");
        out.popDepth();
        out.println("}");
        out.println("public void __caucho_preDestroy(Object instance)");
        out.println("{");
        out.println("}");
        out.println("public void __caucho_postConstruct(Object instance)");
        out.println("{");
        out.println("}");
        out.println();
        out.println("public " + this.getViewClassName() + " __caucho_get()");
        out.println("{");
        out.println("  return this;");
        out.println("}");
        out.popDepth();
        out.println("}");
    }

    protected void generateTimeoutCallback(JavaWriter out) throws IOException {
        String beanClass = this.getBeanType().getJavaClass().getName();
        out.println();
        out.println("public void __caucho_timeout_callback(java.lang.reflect.Method method, javax.ejb.Timer timer)");
        out.println("  throws IllegalAccessException, java.lang.reflect.InvocationTargetException");
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public void __caucho_timeout_callback(java.lang.reflect.Method method)");
        out.println("  throws IllegalAccessException, java.lang.reflect.InvocationTargetException");
        out.println("{");
        out.pushDepth();
        out.popDepth();
        out.println("}");
    }

    protected void generateExtends(JavaWriter out) throws IOException {
        if (!this.isProxy()) {
            out.print("extends ");
            out.printClass(this.getBeanType().getJavaClass());
        }
    }

    public void generateProxyPool(JavaWriter out) throws IOException {
        out.println();
        out.println("public void __caucho_destroy()");
        out.println("{");
        out.println("  _statelessPool.destroy();");
        out.println("}");
    }

    public void generateProxyCall(JavaWriter out, Method implMethod) throws IOException {
        if (!Void.TYPE.equals(implMethod.getReturnType())) {
            out.printClass(implMethod.getReturnType());
            out.println(" result;");
        }
        out.println(this.getBeanClassName() + " bean = _statelessPool.allocate();");
        if (!Void.TYPE.equals(implMethod.getReturnType())) {
            out.print("result = ");
        }
        out.print("bean." + implMethod.getName() + "(");
        Class<?>[] types = implMethod.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.print(" a" + i);
        }
        out.println(");");
        out.println("_ejb_free(bean);");
        if (!Void.TYPE.equals(implMethod.getReturnType())) {
            out.println("return result;");
        }
    }

    protected void generateSuper(JavaWriter out, String serverVar) throws IOException {
        out.println("super(" + serverVar + ");");
    }

    @Override
    public void generateTimer(JavaWriter out) throws IOException {
        if (this._timeoutMethod != null) {
            String beanClassName = this.getBeanType().getJavaClass().getName();
            out.println("StatelessPool.Item<" + beanClassName + "> item");
            out.println("  = _statelessPool.allocate();");
            out.println("try {");
            out.println("  item.getValue()." + this._timeoutMethod + "(timer);");
            out.println("} finally {");
            out.println("  _statelessPool.free(item);");
            out.println("}");
        }
    }
}

