/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.hessian;

import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class HessianXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(HessianXAResource.class.getName());
    private String _url;
    private Path _path;

    public HessianXAResource(String url) {
        this._url = url;
        this._path = Vfs.lookup(url);
    }

    @Override
    public boolean isSameRM(XAResource xares) {
        if (!(xares instanceof HessianXAResource)) {
            return false;
        }
        HessianXAResource rm = (HessianXAResource)xares;
        return this._url.equals(rm._url);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return true;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    @Override
    public void forget(Xid xid) throws XAException {
    }

    @Override
    public void rollback(Xid xid) throws XAException {
    }

    @Override
    public void commit(Xid xid, boolean onephase) throws XAException {
    }

    private static String xidToString(Xid xid) {
        byte[] id = xid.getGlobalTransactionId();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < id.length; ++i) {
            byte b = id[i];
            sb.append(HessianXAResource.toHex(b >> 4 & 0xF));
            sb.append(HessianXAResource.toHex(b & 0xF));
        }
        return sb.toString();
    }

    private static char toHex(int d) {
        if (d < 10) {
            return (char)(48 + d);
        }
        return (char)(97 + d - 10);
    }
}

