/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.server;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.LineConfigException;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.ResourceGroupConfig;
import com.caucho.ejb.cfg.AroundInvokeConfig;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.manager.EjbModule;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.server.EjbInjectionTarget;
import com.caucho.inject.RequestContext;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.transaction.UserTransactionProxy;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.DependsOn;
import javax.ejb.FinderException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public abstract class AbstractEjbBeanManager<X>
implements EnvironmentBean {
    private static final Logger log = Logger.getLogger(AbstractEjbBeanManager.class.getName());
    private static final L10N L = new L10N(AbstractEjbBeanManager.class);
    protected final EjbManager _ejbManager;
    private final EjbModule _ejbModule;
    private String _moduleName;
    protected final UserTransaction _ut = UserTransactionProxy.getInstance();
    protected String _filename;
    protected int _line;
    protected String _location;
    protected Class<X> _ejbClass;
    private AnnotatedType<X> _rawAnnotatedType;
    private AnnotatedType<X> _annotatedType;
    private Bean<X> _bean;
    private String _id;
    private final String _ejbName;
    protected String _mappedName;
    private ArrayList<Class<?>> _remoteApiList = new ArrayList();
    private Context _jndiEnv;
    private EnvironmentClassLoader _loader;
    private ConfigProgram _serverProgram;
    private ArrayList<ResourceGroupConfig> _resourceList;
    private EjbInjectionTarget<X> _producer;
    private boolean _isContainerTransaction = true;
    private long _transactionTimeout;
    private final Lifecycle _lifecycle = new Lifecycle();
    private InjectManager _moduleInjectManager;
    private InjectManager _ejbInjectManager;

    public AbstractEjbBeanManager(EjbManager ejbManager, String ejbName, String moduleName, AnnotatedType<X> rawAnnotatedType, AnnotatedType<X> annotatedType) {
        this._ejbName = ejbName;
        this._rawAnnotatedType = rawAnnotatedType;
        this._annotatedType = annotatedType;
        this._ejbManager = ejbManager;
        this._ejbModule = EjbModule.getCurrent();
        if (moduleName == null) {
            moduleName = this._ejbModule.getModuleName();
        }
        this._moduleName = moduleName;
        if (this._ejbModule == null) {
            throw new IllegalStateException(L.l("EjbModule is not currently defined."));
        }
        this._loader = EnvironmentClassLoader.create(ejbManager.getClassLoader());
        this._loader.setAttribute("caucho.inject", false);
        this._loader.setAttribute("ejb.manager", false);
        this._loader.setId("ejb:" + ejbName);
        this._producer = this.createInjectionTarget();
        this._moduleInjectManager = InjectManager.create();
        this._ejbInjectManager = InjectManager.create(this._loader);
        this._ejbInjectManager.setJndiClassLoader(this._moduleInjectManager.getClassLoader());
    }

    protected EjbInjectionTarget<X> createInjectionTarget() {
        return new EjbInjectionTarget<X>(this, this.getAnnotatedType());
    }

    public String getId() {
        return this._id;
    }

    public InjectManager getModuleInjectManager() {
        return this._moduleInjectManager;
    }

    public InjectManager getInjectManager() {
        return this._ejbInjectManager;
    }

    public void setId(String id) {
        this._id = id;
        int p = id.lastIndexOf(47);
        if (p > 0) {
            this._loader.setId(this.getType() + id.substring(p + 1));
        } else {
            this._loader.setId(this.getType() + id);
        }
    }

    public void setConfigLocation(String filename, int line) {
        this._filename = filename;
        this._line = line;
    }

    public void setLocation(String location) {
        this._location = location;
    }

    protected String getType() {
        return "ejb:";
    }

    public Bean<X> getDeployBean() {
        return this._bean;
    }

    public void setAroundInvoke(AroundInvokeConfig aroundInvoke) {
    }

    public String getEJBName() {
        return this._ejbName;
    }

    public String getModuleName() {
        return this._moduleName;
    }

    public void setMappedName(String mappedName) {
        if (mappedName == null) {
            this._mappedName = null;
            return;
        }
        while (mappedName.startsWith("/")) {
            mappedName = mappedName.substring(1);
        }
        while (mappedName.endsWith("/")) {
            mappedName = mappedName.substring(0, mappedName.length() - 1);
        }
        this._mappedName = mappedName;
    }

    public String getMappedName() {
        return this._mappedName == null ? this.getEJBName() : this._mappedName;
    }

    public String getProtocolId() {
        return "/" + this.getMappedName();
    }

    public String getProtocolId(Class<?> cl) {
        if (cl == null) {
            return this.getProtocolId();
        }
        if (cl.getName().startsWith("java.")) {
            return this.getProtocolId();
        }
        String url = this.getProtocolId() + "#" + cl.getName().replace(".", "_");
        return url;
    }

    public AnnotatedType<X> getRawAnnotatedType() {
        return this._rawAnnotatedType;
    }

    public AnnotatedType<X> getAnnotatedType() {
        return this._annotatedType;
    }

    public void setEjbClass(Class<X> cl) {
        this._ejbClass = cl;
    }

    public Class<X> getEjbClass() {
        return this._annotatedType.getJavaClass();
    }

    public void setRemoteApiList(ArrayList<Class<?>> list) {
        this._remoteApiList = new ArrayList(list);
    }

    public ArrayList<Class<?>> getRemoteApiList() {
        return this._remoteApiList;
    }

    public boolean hasRemoteObject() {
        return this._remoteApiList.size() > 0;
    }

    public ArrayList<AnnotatedType<? super X>> getLocalApi() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public ArrayList<AnnotatedType<? super X>> getRemoteApi() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public AnnotatedType<X> getLocalBean() {
        return null;
    }

    public String encodeId(Object primaryKey) {
        return String.valueOf(primaryKey);
    }

    public boolean isDependValid(ArrayList<AbstractEjbBeanManager<?>> bindList) {
        DependsOn dependsOn = (DependsOn)this.getAnnotatedType().getAnnotation(DependsOn.class);
        if (dependsOn == null) {
            return true;
        }
        for (String dep : dependsOn.value()) {
            if (this.isStarted(dep, bindList)) continue;
            return false;
        }
        return true;
    }

    private boolean isStarted(String dep, ArrayList<AbstractEjbBeanManager<?>> bindList) {
        for (AbstractEjbBeanManager<?> manager : bindList) {
            if (!dep.equals(manager.getEJBName())) continue;
            return true;
        }
        return false;
    }

    public Object lookup(String jndiName) {
        try {
            if (this._jndiEnv == null) {
                this._jndiEnv = new InitialContext();
            }
            if (jndiName == null) {
                throw new IllegalArgumentException();
            }
            if (jndiName.indexOf(58) < 0) {
                jndiName = "java:comp/env/" + jndiName;
            }
            return this._jndiEnv.lookup(jndiName);
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public UserTransaction getUserTransaction() {
        return this._ut;
    }

    public EjbManager getEjbContainer() {
        return this._ejbManager;
    }

    public void setServerProgram(ConfigProgram serverProgram) {
        this._serverProgram = serverProgram;
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public void setTransactionTimeout(long timeout) {
        this._transactionTimeout = timeout;
    }

    public long getTransactionTimeout() {
        return this._transactionTimeout;
    }

    @Configurable
    public void setBusinessLocal(Class<?> local) {
    }

    public TimerService getTimerService() {
        TimerService service = this._producer.getTimerService();
        if (service != null) {
            return service;
        }
        throw new UnsupportedOperationException(L.l("'{0}' does not support a timer service because it does not have a @Timeout method", (Object)this));
    }

    public void invalidateCache() {
    }

    @Override
    public DynamicClassLoader getClassLoader() {
        return this._loader;
    }

    public void bind() {
    }

    public abstract <T> T getRemoteObject(Class<T> var1, String var2);

    public abstract <T> T getLocalProxy(Class<T> var1);

    public abstract <T> Object getLocalJndiProxy(Class<T> var1);

    public AbstractContext<X> getContext() {
        return null;
    }

    public AbstractContext<?> getContext(Object key) throws FinderException {
        return this.getContext(key, true);
    }

    public abstract AbstractContext<?> getContext(Object var1, boolean var2) throws FinderException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(Timer timer) {
        try {
            RequestContext.begin();
            OwnerCreationalContext env = new OwnerCreationalContext((Contextual<?>)this._producer.getBean());
            Object instance = this.newInstance(env);
            Method method = this._producer.getTimeoutMethod();
            if (method.getParameterTypes().length == 0) {
                method.invoke(instance, new Object[0]);
            } else {
                method.invoke(instance, timer);
            }
            this.destroy(instance, env);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            RequestContext.end();
        }
    }

    public void init() throws Exception {
        this._loader.init();
    }

    public X newInstance(CreationalContextImpl<X> env) {
        return this._producer.newInstance(env);
    }

    public void destroy(Object instance, CreationalContextImpl<?> env) {
    }

    public void destroyInstance(X instance) {
        this._producer.destroyInstance(instance);
    }

    public boolean start() throws Exception {
        if (!this._lifecycle.toActive()) {
            return false;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            this._loader.start();
            if (this._serverProgram != null) {
                this._serverProgram.configure(this);
            }
            this.bindInjection();
            this.postStart();
            log.config(this + " active");
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    protected void bindContext() {
        for (ResourceGroupConfig resource : this._resourceList) {
            resource.deploy();
        }
    }

    protected void registerInjection() {
        this._producer.setEnvLoader(this._loader);
        this._producer.registerInjection();
    }

    protected void bindInjection() {
        this._producer.setEnvLoader(this._loader);
        this._producer.bindInjection();
    }

    protected void postStart() {
    }

    public boolean isContainerTransaction() {
        return this._isContainerTransaction;
    }

    public void setContainerTransaction(boolean isContainerTransaction) {
        this._isContainerTransaction = isContainerTransaction;
    }

    public void setResourceList(ArrayList<ResourceGroupConfig> resourceList) {
        this._resourceList = resourceList;
    }

    public boolean isDead() {
        return !this._lifecycle.isActive();
    }

    public void destroy() {
        this._lifecycle.toDestroy();
    }

    public ConfigException error(String msg) {
        if (this._filename != null) {
            throw new LineConfigException(this._filename, this._line, msg);
        }
        throw new ConfigException(msg);
    }

    public String toString() {
        if (this.getMappedName() != null) {
            return this.getClass().getSimpleName() + "[" + this.getEJBName() + "," + this.getMappedName() + "]";
        }
        return this.getClass().getSimpleName() + "[" + this.getEJBName() + "]";
    }
}

