/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.server;

import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.DependentCreationalContext;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionTargetBuilder;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.config.j2ee.PostConstructProgram;
import com.caucho.config.program.ConfigProgram;
import com.caucho.ejb.cfg.PostConstructConfig;
import com.caucho.ejb.cfg.PreDestroyConfig;
import com.caucho.ejb.server.AbstractEjbBeanManager;
import com.caucho.ejb.timer.EjbTimerService;
import com.caucho.ejb.xa.XaInterceptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.TimedObject;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;

public class EjbInjectionTarget<T> {
    private AbstractEjbBeanManager<T> _manager;
    private Class<T> _ejbClass;
    private AnnotatedType<T> _annotatedType;
    private ManagedBeanImpl<T> _bean;
    private AtomicBoolean _isBind = new AtomicBoolean();
    private ClassLoader _envLoader;
    private InjectionTarget<T> _injectionTarget;
    private ArrayList<ConfigProgram> _resourceProgram;
    private PreDestroyConfig _preDestroyConfig;
    private PostConstructConfig _postConstructConfig;
    private Method _cauchoPostConstruct;
    private Method _timeoutMethod;
    private TimerService _timerService;

    EjbInjectionTarget(AbstractEjbBeanManager<T> manager, AnnotatedType<T> annotatedType) {
        this._manager = manager;
        this._ejbClass = annotatedType.getJavaClass();
        this._annotatedType = annotatedType;
        try {
            this._cauchoPostConstruct = this._ejbClass.getDeclaredMethod("__caucho_postConstruct", new Class[0]);
            this._cauchoPostConstruct.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void setEnvLoader(ClassLoader envLoader) {
        this._envLoader = envLoader;
    }

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this._injectionTarget = injectionTarget;
        if (injectionTarget instanceof InjectionTargetBuilder) {
            InjectionTargetBuilder targetImpl = (InjectionTargetBuilder)injectionTarget;
            targetImpl.setGenerateInterception(false);
            ConfigProgram[] initProgram = targetImpl.getPostConstructProgram();
            ConfigProgram[] extInitProgram = new ConfigProgram[initProgram.length];
            for (int i = 0; i < initProgram.length; ++i) {
                PostConstructProgram pcProgram;
                AnnotatedMethod<?> annMethod;
                ConfigProgram program = null;
                if (program instanceof PostConstructProgram && (annMethod = (pcProgram = (PostConstructProgram)program).getAnnotatedMethod()) != null) {
                    program = XaInterceptor.create(annMethod);
                }
                extInitProgram[i] = program != null ? program : initProgram[i];
            }
            targetImpl.setPostConstructProgram(extInitProgram);
        }
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this._injectionTarget;
    }

    public PostConstructConfig getPostConstruct() {
        return this._postConstructConfig;
    }

    public PreDestroyConfig getPreDestroy() {
        return this._preDestroyConfig;
    }

    public void setPostConstruct(PostConstructConfig postConstruct) {
        this._postConstructConfig = postConstruct;
    }

    public void setPreDestroy(PreDestroyConfig preDestroy) {
        this._preDestroyConfig = preDestroy;
    }

    public TimerService getTimerService() {
        return this._timerService;
    }

    public Method getTimeoutMethod() {
        return this._timeoutMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInjection() {
        if (this._bean != null) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._manager.getClassLoader());
            InjectManager cdiManager = InjectManager.create();
            ManagedBeanImpl<T> managedBean = cdiManager.createManagedBean(this._annotatedType);
            this._bean = managedBean;
            this._timeoutMethod = this.getTimeoutMethod(this._bean.getBeanClass());
            if (this._timeoutMethod != null) {
                this._timerService = new EjbTimerService(this._manager);
            }
            if (this._timerService != null) {
                BeanBuilder<TimerService> factory = cdiManager.createBeanFactory(TimerService.class);
                cdiManager.addBeanDiscover(factory.singleton(this._timerService));
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindInjection() {
        this.registerInjection();
        if (!this._isBind.compareAndSet(false, true)) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._manager.getClassLoader());
            InjectManager cdiManager = InjectManager.create();
            this.setInjectionTarget(this._bean.getInjectionTarget());
            if (this._injectionTarget == null) {
                this._injectionTarget = cdiManager.createInjectionTarget(this._ejbClass);
                this._injectionTarget.getInjectionPoints();
            }
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    Bean<?> getBean() {
        return this._bean;
    }

    private Method getTimeoutMethod(Class<?> targetBean) {
        if (TimedObject.class.isAssignableFrom(targetBean)) {
            try {
                return targetBean.getMethod("ejbTimeout", Timer.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        for (Method method : targetBean.getMethods()) {
            if (method.getAnnotation(Timeout.class) == null) continue;
            return method;
        }
        return null;
    }

    public T newInstance() {
        return this.newInstance(null);
    }

    public T newInstance(CreationalContextImpl<?> parentEnv) {
        Object instance;
        if (!this._isBind.get()) {
            this.bindInjection();
        }
        if ((instance = CreationalContextImpl.find(parentEnv, this._bean)) != null) {
            return instance;
        }
        if (parentEnv == null) {
            parentEnv = new OwnerCreationalContext((Contextual<?>)this._bean);
        }
        DependentCreationalContext<T> env = new DependentCreationalContext<T>(this._bean, parentEnv, null);
        instance = this._injectionTarget.produce(env);
        this._injectionTarget.inject(instance, env);
        this.postConstruct(instance);
        return instance;
    }

    protected void postConstruct(T instance) {
        this._injectionTarget.postConstruct(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <X> void initInstance(T instance, InjectionTarget<T> target, X proxy, CreationalContextImpl<X> proxyEnv) {
        ManagedBeanImpl<T> bean = this._bean;
        if (proxyEnv != null && bean != null) {
            proxyEnv.push(proxy);
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        DependentCreationalContext<T> cxt = new DependentCreationalContext<T>(bean, proxyEnv, null);
        try {
            InjectionTarget<T> selfInjectionTarget;
            thread.setContextClassLoader(this._envLoader);
            if (target != null) {
                target.inject(instance, cxt);
            }
            if ((selfInjectionTarget = this.getInjectionTarget()) != null && target != selfInjectionTarget) {
                selfInjectionTarget.inject(instance, cxt);
            }
            for (ConfigProgram program : this._resourceProgram) {
                program.inject(instance, cxt);
            }
            if (selfInjectionTarget != null) {
                selfInjectionTarget.postConstruct(instance);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyInstance(T instance) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._envLoader);
            if (this.getInjectionTarget() != null) {
                this.getInjectionTarget().preDestroy(instance);
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ejbClass + "]";
    }
}

