/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor;

import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor.ActorQueueApi;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.util.RingValueQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MultiworkerActorQueue<T>
implements ActorQueueApi<T> {
    private static final Logger log = Logger.getLogger(MultiworkerActorQueue.class.getName());
    private final RingValueQueue<T> _ringQueue;
    private final int _multiworkerOffset;
    private final ActorProcessor<? super T>[] _processors;
    private final ActorWorker<T>[] _workers;

    public MultiworkerActorQueue(int capacity, int multiworkerOffset, ActorProcessor<? super T> ... processors) {
        if (processors == null) {
            throw new NullPointerException();
        }
        this._processors = processors;
        this._ringQueue = new RingValueQueue(capacity);
        this._workers = new ActorWorker[processors.length];
        for (int i = 0; i < this._workers.length; ++i) {
            this._workers[i] = new ActorWorker<T>(this._ringQueue, processors[i]);
        }
        this._multiworkerOffset = Math.max(1, multiworkerOffset);
    }

    @Override
    public int getAvailable() {
        return this._ringQueue.getCapacity() - this._ringQueue.size();
    }

    @Override
    public boolean isEmpty() {
        return this._ringQueue.isEmpty();
    }

    @Override
    public int getSize() {
        return this._ringQueue.size();
    }

    @Override
    public final void offer(T value) {
        this.offer(value, true);
    }

    @Override
    public final boolean offer(T value, boolean isWait) {
        boolean result = this._ringQueue.offer(value, isWait ? 600000L : 0L, TimeUnit.MILLISECONDS);
        this.wake();
        return result;
    }

    @Override
    public void wake() {
        int size = this.getSize();
        int count = (size + this._multiworkerOffset - 1) / this._multiworkerOffset;
        for (int i = 0; i < count && i < this._workers.length; ++i) {
            this._workers[i].wake();
        }
    }

    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._processors[0] + "]";
    }

    private static class ActorWorker<T>
    extends AbstractTaskWorker {
        private final RingValueQueue<T> _queue;
        private final ActorProcessor<? super T> _processor;

        ActorWorker(RingValueQueue<T> queue, ActorProcessor<? super T> processor) {
            this._queue = queue;
            this._processor = processor;
        }

        @Override
        public long runTask() {
            try {
                Object value;
                while ((value = this._queue.poll()) != null) {
                    this._processor.process(value);
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            finally {
                try {
                    this._processor.onProcessComplete();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            return 0L;
        }
    }
}

