/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor2;

import com.caucho.env.actor2.ArrayRing;
import com.caucho.util.L10N;

final class ArrayRingPlain<T>
implements ArrayRing<T> {
    private static final L10N L = new L10N(ArrayRingPlain.class);
    private final T[] _ring;
    private final int _length;
    private final int _mask;

    ArrayRingPlain(int length) {
        this._length = length;
        if (Integer.bitCount(this._length) != 1) {
            throw new IllegalArgumentException(L.l("Invalid ring capacity {0}", (Object)Long.toHexString(this._length)));
        }
        this._ring = new Object[this._length];
        this._mask = this._length - 1;
    }

    @Override
    public final int getLength() {
        return this._length;
    }

    @Override
    public final T get(long index) {
        return this._ring[this.getIndex(index)];
    }

    @Override
    public final void set(long ptr, T value) {
        int index = this.getIndex(ptr);
        this._ring[index] = value;
    }

    @Override
    public final void setLazy(long ptr, T value) {
        this._ring[this.getIndex((long)ptr)] = value;
    }

    @Override
    public final T takeAndClear(long ptr) {
        T value;
        T[] ring = this._ring;
        int index = this.getIndex(ptr);
        while ((value = ring[index]) == null) {
        }
        ring[index] = null;
        return value;
    }

    @Override
    public final void clear(long ptr, long end) {
        T[] ring = this._ring;
        while (ptr < end) {
            ring[this.getIndex((long)ptr)] = null;
            ++ptr;
        }
    }

    @Override
    public final T pollAndClear(long ptr) {
        T[] ring = this._ring;
        int index = this.getIndex(ptr);
        T value = ring[index];
        if (value != null && ring[index] == value) {
            ring[index] = null;
            return value;
        }
        return null;
    }

    @Override
    public final int getIndex(long ptr) {
        return (int)(ptr & (long)this._mask);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._ring.getClass().getSimpleName() + "," + this.getLength() + "]";
    }
}

