/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.actor2;

import com.caucho.env.actor2.RingBlocker;
import com.caucho.util.CurrentTime;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RingBlockerBasic
implements RingBlocker {
    private static final Logger log = Logger.getLogger(RingBlockerBasic.class.getName());
    private final AtomicLong _offerWaitSequence = new AtomicLong();
    private final AtomicLong _offerWakeSequence = new AtomicLong();
    private boolean _isOfferWait;
    private final AtomicLong _pollWaitSequence = new AtomicLong();
    private final AtomicLong _pollWakeSequence = new AtomicLong();
    private boolean _isPollWait;

    @Override
    public final long nextOfferSequence() {
        return this._offerWaitSequence.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean offerWait(long sequence, long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            return false;
        }
        if (!this._isOfferWait) {
            this._isOfferWait = true;
        }
        long now = CurrentTime.getCurrentTimeActual();
        long expires = now + unit.toMillis(timeout);
        this.pollWake();
        AtomicLong atomicLong = this._offerWaitSequence;
        synchronized (atomicLong) {
            while (this._offerWakeSequence.get() < sequence && (now = CurrentTime.getCurrentTimeActual()) < expires) {
                try {
                    long millis = Math.max(0L, expires - now);
                    this._offerWaitSequence.wait(millis);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    Thread.interrupted();
                }
            }
        }
        return sequence <= this._offerWakeSequence.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void offerWake() {
        if (!this._isOfferWait) {
            return;
        }
        long wakeSequence = this._offerWakeSequence.get();
        long waitSequence = this._offerWaitSequence.get();
        while (wakeSequence < waitSequence) {
            if (this._offerWakeSequence.compareAndSet(wakeSequence, waitSequence)) {
                AtomicLong atomicLong = this._offerWaitSequence;
                synchronized (atomicLong) {
                    this._offerWaitSequence.notifyAll();
                    break;
                }
            }
            wakeSequence = this._offerWakeSequence.get();
        }
    }

    @Override
    public final boolean wake() {
        this.offerWake();
        return true;
    }

    @Override
    public final void wakeAll() {
        this.wake();
    }

    @Override
    public final long nextPollSequence() {
        return this._pollWaitSequence.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pollWait(long sequence, long timeout, TimeUnit unit) {
        if (timeout <= 0L) {
            return false;
        }
        if (!this._isPollWait) {
            this._isPollWait = true;
        }
        long expires = CurrentTime.getCurrentTimeActual() + unit.toMillis(timeout);
        this.offerWake();
        AtomicLong atomicLong = this._pollWaitSequence;
        synchronized (atomicLong) {
            long now;
            while (this._pollWakeSequence.get() < sequence && (now = CurrentTime.getCurrentTimeActual()) < expires) {
                try {
                    long millis = Math.max(0L, expires - now);
                    this._pollWaitSequence.wait(millis);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                    Thread.interrupted();
                }
            }
        }
        return sequence <= this._pollWakeSequence.get();
    }

    @Override
    public final boolean isPollWait() {
        if (!this._isPollWait) {
            return false;
        }
        return this._pollWakeSequence.get() < this._pollWaitSequence.get();
    }

    @Override
    public void pollWake() {
        if (this.isPollWait()) {
            this.pollWakeImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pollWakeImpl() {
        AtomicLong atomicLong = this._pollWaitSequence;
        synchronized (atomicLong) {
            if (this.isPollWait()) {
                this._pollWakeSequence.set(this._pollWaitSequence.get());
                this._pollWaitSequence.notifyAll();
            }
        }
    }
}

