/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositorySystem;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.util.Crc64;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

class ExpandRepositoryManager {
    private final String _tagPrefix;
    private final Repository _repository;
    private TreeSet<String> _keySet = new TreeSet();
    private long _digest;
    private Map<String, RepositoryTagEntry> _oldRepositoryMap;

    public ExpandRepositoryManager(String id) {
        this._tagPrefix = id + "/";
        this._repository = RepositorySystem.getCurrentRepository();
    }

    boolean isModified() {
        if (this._oldRepositoryMap == this._repository.getTagMap()) {
            return false;
        }
        long newDigest = this.calculateDigest();
        return this._digest != newDigest;
    }

    boolean logModified(Logger log) {
        long digest = this.calculateDigest();
        if (this._digest != digest) {
            log.info(this + " is modified");
            return true;
        }
        return false;
    }

    TreeSet<String> getDeployedKeys() {
        long oldDigest = this._digest;
        TreeSet<String> oldKeys = this._keySet;
        long newDigest = this.calculateDigest();
        if (oldDigest == newDigest) {
            return oldKeys;
        }
        try {
            TreeSet<String> newKeys = this.scanKeys();
            this._digest = newDigest;
            this._keySet = newKeys;
            return newKeys;
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    public long calculateDigest() {
        long digest = 0L;
        String prefix = this._tagPrefix;
        ArrayList<String> tags = new ArrayList<String>();
        Map<String, RepositoryTagEntry> tagMap = this._repository.getTagMap();
        for (String key : tagMap.keySet()) {
            if (!key.startsWith(prefix)) continue;
            tags.add(key);
        }
        Collections.sort(tags);
        for (String tag : tags) {
            digest = Crc64.generate(digest, tag);
            RepositoryTagEntry entry = tagMap.get(tag);
            if (entry.getRoot() == null) continue;
            digest = Crc64.generate(digest, entry.getRoot());
        }
        return digest;
    }

    private TreeSet<String> scanKeys() throws IOException {
        TreeSet<String> keySet = new TreeSet<String>();
        String prefix = this._tagPrefix;
        Map<String, RepositoryTagEntry> tagMap = this._repository.getTagMap();
        for (String tag : tagMap.keySet()) {
            if (!tag.startsWith(prefix)) continue;
            String key = tag.substring(prefix.length());
            int p = key.indexOf(47);
            if (p >= 0) {
                key = key.substring(0, p);
            }
            keySet.add(key);
        }
        return keySet;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._tagPrefix + "]";
    }
}

