/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.ExpandVersion;
import com.caucho.env.deploy.ExpandVersionGroup;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class ExpandVersionManager {
    private final String _id;
    private final boolean _isVersioning;
    private final TreeMap<String, ExpandVersion> _versionMap;
    private final TreeMap<String, ExpandVersionGroup> _baseVersionMap;

    public ExpandVersionManager(String id, TreeSet<String> keySet, boolean isVersioning) {
        this._id = id;
        this._isVersioning = isVersioning;
        this._versionMap = this.buildVersionMap(keySet);
        this._baseVersionMap = this.buildVersionGroupMap(this._versionMap);
    }

    public ExpandVersion getVersion(String key) {
        if (key != null) {
            return this._versionMap.get(key);
        }
        return null;
    }

    public ExpandVersionGroup getBaseVersionGroup(String baseKey) {
        if (baseKey != null) {
            return this._baseVersionMap.get(baseKey);
        }
        return null;
    }

    public ExpandVersion getPrimaryVersion(String baseKey) {
        ExpandVersionGroup versionGroup = this.getBaseVersionGroup(baseKey);
        if (versionGroup != null) {
            return versionGroup.getPrimaryVersion();
        }
        return null;
    }

    public Set<String> getBaseKeySet() {
        return this._baseVersionMap.keySet();
    }

    public Set<String> getKeySet() {
        return this._versionMap.keySet();
    }

    private TreeMap<String, ExpandVersion> buildVersionMap(TreeSet<String> keySet) {
        TreeMap<String, ExpandVersion> versionMap = new TreeMap<String, ExpandVersion>();
        for (String key : keySet) {
            ExpandVersion version = this.createVersion(key);
            versionMap.put(key, version);
        }
        return versionMap;
    }

    private ExpandVersion createVersion(String key) {
        String baseKey = key;
        String version = "";
        int p = baseKey.lastIndexOf(45);
        if (p > 0) {
            version = key.substring(p + 1);
            if (this.isValidVersion(version)) {
                baseKey = key.substring(0, p);
            } else {
                version = "";
            }
        }
        return new ExpandVersion(key, baseKey, version);
    }

    private boolean isValidVersion(String version) {
        if (!this._isVersioning) {
            return false;
        }
        int length = version.length();
        boolean isDigit = false;
        for (int i = 0; i < length; ++i) {
            char ch = version.charAt(i);
            if ('0' > ch || ch > '9') {
                if (ch == '.') {
                    return isDigit;
                }
                return false;
            }
            isDigit = true;
        }
        return isDigit;
    }

    private TreeMap<String, ExpandVersionGroup> buildVersionGroupMap(TreeMap<String, ExpandVersion> versionMap) {
        TreeMap<String, ExpandVersionGroup> baseVersionMap = new TreeMap<String, ExpandVersionGroup>();
        for (ExpandVersion version : versionMap.values()) {
            String baseKey = version.getBaseKey();
            ExpandVersionGroup versionGroup = baseVersionMap.get(baseKey);
            if (versionGroup == null) {
                versionGroup = new ExpandVersionGroup(version);
                baseVersionMap.put(baseKey, versionGroup);
                continue;
            }
            versionGroup.addVersion(version);
        }
        return baseVersionMap;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

