/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.health;

import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HealthSystemFacade {
    private static final Logger log = Logger.getLogger(HealthSystemFacade.class.getName());
    public static final String RESIN_EXIT_MESSAGE = "resin.exit.message";
    private static final HealthSystemFacade _facade;

    protected HealthSystemFacade() {
    }

    public static String getExitMessage() {
        String msg = System.getProperty(RESIN_EXIT_MESSAGE);
        if (msg != null) {
            return msg;
        }
        return "";
    }

    public static void fireEvent(String eventName, String eventMessage) {
        _facade.fireEventImpl(eventName, eventMessage);
    }

    public static void fireFatalEvent(String eventName, String eventMessage) {
        _facade.fireFatalEventImpl(eventName, eventMessage);
    }

    protected void fireEventImpl(String eventName, String eventMessage) {
    }

    protected void fireFatalEventImpl(String eventName, String eventMessage) {
        ShutdownSystem.shutdownActive(ExitCode.HEALTH, eventName + ": " + eventMessage);
    }

    static {
        HealthSystemFacade facade = new HealthSystemFacade();
        try {
            Class<?> cl = Class.forName("com.caucho.env.health.ProHealthSystemFacade");
            facade = (HealthSystemFacade)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.log(Level.ALL, e.toString(), e);
        }
        catch (Throwable e) {
            log.log(Level.FINER, e.toString(), e);
        }
        _facade = facade;
    }
}

