/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.repository;

import com.caucho.env.git.GitCommit;
import com.caucho.env.git.GitTree;
import com.caucho.env.git.GitType;
import com.caucho.env.repository.AbstractRepository;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.inject.Module;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;

@Module
public class RepositoryTagMap {
    private static final Logger log = Logger.getLogger(RepositoryTagMap.class.getName());
    private static final L10N L = new L10N(RepositoryTagMap.class);
    private final String _commitHash;
    private final GitCommit _commit;
    private final long _sequence;
    private final GitTree _tree;
    private final Map<String, RepositoryTagEntry> _tagMap;

    public RepositoryTagMap() {
        this._commitHash = "";
        this._commit = null;
        this._sequence = 0L;
        this._tagMap = Collections.unmodifiableMap(new HashMap());
        this._tree = null;
    }

    public RepositoryTagMap(AbstractRepository repository, String commitHash, boolean isValidate) throws IOException {
        this._commitHash = commitHash;
        if (commitHash == null) {
            throw new NullPointerException();
        }
        if (isValidate) {
            repository.validateHash(commitHash, commitHash);
        }
        this._commit = repository.readCommit(commitHash);
        String sequence = this._commit.get("sequence");
        this._sequence = sequence != null ? Long.parseLong(sequence) : 1L;
        this._tree = repository.readTree(this._commit.getTree());
        this._tagMap = this.readTagMap(repository, this._tree.getHash("tags"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryTagMap(AbstractRepository repository, RepositoryTagMap parent, Map<String, RepositoryTagEntry> tagMap) throws IOException {
        String tagHash;
        this._tagMap = Collections.unmodifiableMap(tagMap);
        long now = CurrentTime.getCurrentTime();
        this._sequence = parent.getSequence() < now ? now : parent.getSequence() + 1L;
        TempStream os = new TempStream();
        WriteStream out = new WriteStream(os);
        this.writeTagMap(out);
        out.close();
        InputStream is = os.getInputStream();
        try {
            tagHash = repository.addBlob(is);
        }
        finally {
            is.close();
        }
        this._tree = new GitTree();
        this._tree.addBlob("tags", 509, tagHash);
        for (String key : tagMap.keySet()) {
            RepositoryTagEntry entry = tagMap.get(key);
            String sha1 = entry.getTagEntryHash();
            String root = entry.getRoot();
            this._tree.addBlob(sha1, 420, sha1);
            GitType type = repository.getType(root);
            if (type == GitType.BLOB) {
                this._tree.addBlob(root, 420, root);
                continue;
            }
            if (type == GitType.TREE) {
                this._tree.addDir(root, root);
                continue;
            }
            log.warning(L.l("'{0}' has an unknown type {1}", (Object)root, (Object)type));
        }
        String treeHash = repository.addTree(this._tree);
        this._commit = new GitCommit();
        this._commit.setTree(treeHash);
        this._commit.put("sequence", String.valueOf(this._sequence));
        this._commitHash = repository.addCommit(this._commit);
    }

    public String getCommitHash() {
        return this._commitHash;
    }

    public long getSequence() {
        return this._sequence;
    }

    public Map<String, RepositoryTagEntry> getTagMap() {
        return this._tagMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, RepositoryTagEntry> readTagMap(AbstractRepository repository, String sha1) throws IOException {
        TreeMap<String, RepositoryTagEntry> map = new TreeMap<String, RepositoryTagEntry>();
        InputStream is = repository.openBlob(sha1);
        try {
            String tag;
            ReadStream in = Vfs.openRead(is);
            while ((tag = in.readLine()) != null) {
                String entrySha1 = in.readLine();
                RepositoryTagEntry entry = new RepositoryTagEntry(repository, entrySha1);
                map.put(tag, entry);
            }
        }
        finally {
            is.close();
        }
        return Collections.unmodifiableMap(map);
    }

    private void writeTagMap(WriteStream out) throws IOException {
        for (Map.Entry<String, RepositoryTagEntry> entry : this._tagMap.entrySet()) {
            out.println(entry.getKey());
            out.println(entry.getValue().getTagEntryHash());
        }
    }

    public int compareTo(RepositoryTagMap oldTagMap) {
        if (this.getSequence() < oldTagMap.getSequence()) {
            return -1;
        }
        if (oldTagMap.getSequence() < this.getSequence()) {
            return 1;
        }
        return this.getCommitHash().compareTo(oldTagMap.getCommitHash());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[seq=" + this._sequence + "," + this._commitHash + "]";
    }
}

