/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.thread1;

import com.caucho.util.CurrentTime;
import java.util.concurrent.locks.LockSupport;

final class ThreadTask1 {
    private final Runnable _runnable;
    private final ClassLoader _loader;
    private volatile Thread _thread;

    ThreadTask1(Runnable runnable, ClassLoader loader, Thread thread) {
        this._runnable = runnable;
        this._loader = loader;
        this._thread = thread;
    }

    final Runnable getRunnable() {
        return this._runnable;
    }

    final ClassLoader getLoader() {
        return this._loader;
    }

    void clearThread() {
        this._thread = null;
    }

    final void wake() {
        Thread thread = this._thread;
        this._thread = null;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    final void park(long expires) {
        Thread thread = this._thread;
        while (this._thread != null && CurrentTime.getCurrentTimeActual() < expires) {
            try {
                Thread.interrupted();
                LockSupport.parkUntil(thread, expires);
            }
            catch (Exception exception) {}
        }
        this._thread = null;
    }
}

