/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.ErrorParser;
import com.caucho.java.LineMap;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.ByteToChar;
import java.io.IOException;
import java.io.InputStream;

class JikesErrorParser
extends ErrorParser {
    private ByteToChar token = ByteToChar.create();
    private ByteToChar buf = ByteToChar.create();
    private String filename = "filename";

    JikesErrorParser() {
    }

    @Override
    String parseErrors(InputStream is, LineMap lineMap) throws IOException {
        CharBuffer errors = new CharBuffer();
        this.scanError(is, lineMap, errors);
        return errors.toString();
    }

    private void scanError(InputStream is, LineMap lineMap, CharBuffer errors) throws IOException {
        int ch = is.read();
        ByteToChar sourceLine = ByteToChar.create();
        sourceLine.setEncoding(System.getProperty("file.encoding"));
        this.filename = "filename";
        this.buf.clear();
        while (ch >= 0) {
            int colOffset = 0;
            while (ch >= 0 && (ch == 32 || ch == 9)) {
                ++colOffset;
                ch = is.read();
            }
            int line = 0;
            while (ch >= 0 && ch >= 48 && ch <= 57) {
                line = 10 * line + ch - 48;
                ++colOffset;
                ch = is.read();
            }
            if (ch < 0) {
                return;
            }
            if (colOffset == 0 && !Character.isWhitespace((char)ch)) {
                ch = this.scanUnknownLine(is, ch, errors);
            } else if (ch != 46) {
                ch = this.skipToNewline(is, ch);
                continue;
            }
            sourceLine.clear();
            ch = is.read();
            while (ch >= 0 && ch != 10) {
                sourceLine.addByte(ch);
                ch = is.read();
            }
            sourceLine.addChar('\n');
            int column = 0;
            ch = is.read();
            while (ch >= 0 && ch != 10 && ch != 94) {
                if (ch == 32) {
                    ++column;
                } else if (ch == 9) {
                    column = (column + 8) / 8 * 8;
                }
                ch = is.read();
            }
            for (int i = colOffset + 1; i < column; ++i) {
                sourceLine.addChar(' ');
            }
            sourceLine.addChar('^');
            sourceLine.addChar('\n');
            ch = this.skipToNewline(is, ch);
            if (ch != 42) continue;
            this.buf.clear();
            while (ch >= 0 && ch != 58 && ch != 10) {
                ch = is.read();
            }
            if (ch != 58) {
                ch = this.skipToNewline(is, ch);
                continue;
            }
            ch = is.read();
            while (ch >= 0 && (ch == 32 || ch == 32)) {
                ch = is.read();
            }
            while (ch >= 0 && ch != 10) {
                this.buf.addByte(ch);
                ch = is.read();
            }
            String message = this.buf.getConvertedString();
            if (lineMap != null) {
                errors.append(lineMap.convertError(this.filename, line, 0, message));
            } else {
                errors.append(this.filename + ":" + line + ": " + message);
            }
            errors.append('\n');
            errors.append(sourceLine.getConvertedString());
        }
    }

    private int scanUnknownLine(InputStream is, int ch, CharBuffer errors) throws IOException {
        this.token.clear();
        this.token.addByte(ch);
        ch = is.read();
        while (ch > 0 && !Character.isWhitespace((char)ch)) {
            ch = is.read();
        }
        if (this.token.equals("Found")) {
            return this.scanFilename(is, ch);
        }
        if (this.token.equals("***")) {
            while (ch == 32 || ch == 9) {
                ch = is.read();
            }
            this.token.clear();
            while (ch > 0 && ch != 10 && ch != 58) {
                this.token.addByte(ch);
                ch = is.read();
            }
            if (this.token.equals("Warning")) {
                return this.skipToNewline(is, ch);
            }
            this.token.clear();
            ch = is.read();
            while (ch > 0 && ch != 10) {
                this.token.addByte(ch);
                ch = is.read();
            }
            this.token.addChar('\n');
            errors.append(this.token.getConvertedString());
            return is.read();
        }
        return this.skipToNewline(is, ch);
    }

    private int scanFilename(InputStream is, int ch) throws IOException {
        while (ch >= 0 && ch != 10 && ch != 34) {
            ch = is.read();
        }
        if (ch != 34) {
            return this.skipToNewline(is, ch);
        }
        this.token.clear();
        ch = is.read();
        while (ch >= 0 && ch != 34 && ch != 10) {
            this.token.addByte(ch);
            ch = is.read();
        }
        if (ch != 34) {
            return this.skipToNewline(is, ch);
        }
        this.filename = this.token.getConvertedString();
        return this.skipToNewline(is, ch);
    }

    private int skipToNewline(InputStream is, int ch) throws IOException {
        while (ch >= 0 && ch != 10) {
            ch = is.read();
        }
        return is.read();
    }
}

