/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.Names;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.inject.BeanBuilder;
import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionBean;
import com.caucho.jca.ra.ResourceAdapterController;
import com.caucho.jca.ra.ResourceAdapterProducer;
import com.caucho.jca.ra.ResourceArchive;
import com.caucho.jca.ra.ResourceArchiveManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.spi.Bean;
import javax.resource.spi.ResourceAdapter;

public class ResourceAdapterBeanConfig
extends BeanConfig {
    public ResourceAdapterBeanConfig() {
        this.setBeanConfigClass(ResourceAdapter.class);
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.addProducer();
    }

    private <T> void addProducer() {
        Class<?> type = this.getClassType();
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(type.getName());
        ResourceAdapterController controller = new ResourceAdapterController(this.getComponent(), ra);
        InjectManager beanManager = InjectManager.create();
        BeanBuilder<?> factory = beanManager.createBeanFactory(type);
        factory.type(new Type[]{ResourceAdapter.class, type});
        String name = type.getSimpleName();
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        factory.name(name);
        factory.qualifier((Annotation)Names.create(name));
        factory.qualifier((Annotation)DefaultLiteral.DEFAULT);
        ResourceAdapterProducer producer = new ResourceAdapterProducer(controller);
        Bean<?> bean = factory.injection(producer);
        beanManager.addBeanDiscover(bean);
        ((InjectionBean)bean).introspectProduces();
    }

    @Override
    protected void deploy() {
    }
}

