/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jdbc;

import com.caucho.jdbc.GenericMetaData;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OracleMetaData
extends GenericMetaData {
    private static final Logger log = Logger.getLogger(OracleMetaData.class.getName());

    protected OracleMetaData(DataSource ds) {
        super(ds);
    }

    @Override
    public String getFalseLiteral() {
        return "0";
    }

    @Override
    public boolean isTruncateBlobBeforeDelete() {
        return true;
    }

    @Override
    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        switch (sqlType) {
            case 91: 
            case 92: {
                return "DATE";
            }
            case 8: {
                return "DOUBLE PRECISION";
            }
        }
        return super.getCreateColumnSQL(sqlType, length, precision, scale);
    }

    @Override
    public boolean supportsPositionFunction() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsUpdateTableAlias() {
        return true;
    }

    @Override
    public String createSequenceSQL(String name, int size) {
        if (size > 1) {
            return "CREATE SEQUENCE " + name + " INCREMENT BY " + size;
        }
        return "CREATE SEQUENCE " + name;
    }

    @Override
    public String selectSequenceSQL(String name) {
        return "SELECT " + name + ".nextval FROM DUAL";
    }
}

