/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.connection;

import com.caucho.jms.connection.ConnectionFactoryImpl;
import com.caucho.jms.connection.ConnectionMetaDataImpl;
import com.caucho.jms.connection.JmsSession;
import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.memory.MemoryTopic;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.jms.XAConnection;
import javax.jms.XASession;

public class ConnectionImpl
implements XAConnection {
    static final Logger log = Logger.getLogger(ConnectionImpl.class.getName());
    static final L10N L = new L10N(ConnectionImpl.class);
    private static int _clientIdGenerator;
    private ConnectionFactoryImpl _factory;
    private boolean _isXA;
    private String _clientId;
    private boolean _isClientIdSet;
    private ExceptionListener _exceptionListener;
    private ArrayList<JmsSession> _sessions = new ArrayList();
    private HashMap<String, TopicSubscriber> _durableSubscriberMap = new HashMap();
    private HashMap<String, Queue> _dynamicQueueMap = new HashMap();
    private HashMap<String, Topic> _dynamicTopicMap = new HashMap();
    private final Lifecycle _lifecycle = new Lifecycle(log);

    public ConnectionImpl(ConnectionFactoryImpl factory, boolean isXA) {
        this(factory);
        this._isXA = isXA;
    }

    public ConnectionImpl(ConnectionFactoryImpl factory) {
        this._factory = factory;
        Environment.addCloseListener(this);
    }

    public boolean isXA() {
        return this._isXA;
    }

    public String getClientID() throws JMSException {
        this.checkOpen();
        return this._clientId;
    }

    public void setClientID(String clientId) throws JMSException {
        this.checkOpen();
        if (this._isClientIdSet) {
            throw new IllegalStateException(L.l("Can't set client id '{0}' after the connection has been used.", (Object)clientId));
        }
        ConnectionImpl oldConn = this._factory.findByClientID(clientId);
        if (oldConn != null) {
            throw new InvalidClientIDException(L.l("'{0}' is a duplicate client id.", (Object)clientId));
        }
        this._clientId = clientId;
        this._isClientIdSet = true;
        this._lifecycle.setName(this.toString());
        this._lifecycle.setLevel(Level.FINER);
    }

    public ConnectionFactoryImpl getConnectionFactory() {
        return this._factory;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkOpen();
        return this._exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkOpen();
        this.assignClientID();
        this._exceptionListener = listener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkOpen();
        return new ConnectionMetaDataImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        this.checkOpen();
        this.assignClientID();
        if (!this._lifecycle.toActive()) {
            return;
        }
        ArrayList<JmsSession> arrayList = this._sessions;
        synchronized (arrayList) {
            for (int i = 0; i < this._sessions.size(); ++i) {
                this._sessions.get(i).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        this.checkOpen();
        if (!this._lifecycle.toStopping()) {
            return;
        }
        try {
            this.assignClientID();
            ArrayList<JmsSession> arrayList = this._sessions;
            synchronized (arrayList) {
                for (int i = 0; i < this._sessions.size(); ++i) {
                    try {
                        this._sessions.get(i).stop();
                        continue;
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                }
            }
        }
        finally {
            this._lifecycle.toStop();
        }
    }

    boolean isActive() {
        return this._lifecycle.isActive();
    }

    boolean isStopping() {
        return this._lifecycle.isStopping();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkOpen();
        this.assignClientID();
        return new JmsSession(this, transacted, acknowledgeMode, this.isXA());
    }

    public XASession createXASession() throws JMSException {
        this.checkOpen();
        this.assignClientID();
        return new JmsSession(this, true, 0, true);
    }

    protected void addSession(JmsSession session) {
        this._sessions.add(session);
        if (this._lifecycle.isActive()) {
            session.start();
        }
    }

    void removeSession(JmsSession session) {
        this._sessions.remove(session);
    }

    Queue createQueue(String name) {
        Queue queue = this._dynamicQueueMap.get(name);
        if (queue != null) {
            return queue;
        }
        MemoryQueue memoryQueue = new MemoryQueue();
        memoryQueue.setName(name);
        this._dynamicQueueMap.put(name, memoryQueue);
        return memoryQueue;
    }

    Topic createTopic(String name) {
        Topic topic = this._dynamicTopicMap.get(name);
        if (topic != null) {
            return topic;
        }
        MemoryTopic memoryTopic = new MemoryTopic();
        memoryTopic.setName(name);
        this._dynamicTopicMap.put(name, memoryTopic);
        return memoryTopic;
    }

    TopicSubscriber getDurableSubscriber(String name) {
        return this._durableSubscriberMap.get(name);
    }

    TopicSubscriber putDurableSubscriber(String name, TopicSubscriber subscriber) {
        return this._durableSubscriberMap.put(name, subscriber);
    }

    TopicSubscriber removeDurableSubscriber(String name) {
        return this._durableSubscriberMap.remove(name);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String name, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkOpen();
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        ArrayList<JmsSession> sessions;
        if (this._lifecycle.isDestroyed()) {
            return;
        }
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        this._factory.removeConnection(this);
        ArrayList<JmsSession> arrayList = this._sessions;
        synchronized (arrayList) {
            sessions = new ArrayList<JmsSession>(this._sessions);
            this._sessions.clear();
        }
        for (int i = 0; i < sessions.size(); ++i) {
            try {
                sessions.get(i).close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    protected void checkOpen() throws IllegalStateException {
        if (this._lifecycle.isDestroyed()) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
    }

    protected void assignClientID() {
        if (this._clientId == null) {
            this._clientId = "resin-temp-" + _clientIdGenerator++;
        }
        this._isClientIdSet = true;
        this._lifecycle.setName(this.toString());
    }

    public String toString() {
        return "JmsConnection[" + this._clientId + "]";
    }
}

